# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_ansible.configuration import Configuration


class AnsibleAnsibleNamespaceMetadataResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pulp_href': 'str',
        'name': 'str',
        'company': 'str',
        'email': 'str',
        'description': 'str',
        'resources': 'str',
        'links': 'list[NamespaceLinkResponse]',
        'avatar_sha256': 'str',
        'avatar_url': 'str',
        'metadata_sha256': 'str'
    }

    attribute_map = {
        'pulp_href': 'pulp_href',
        'name': 'name',
        'company': 'company',
        'email': 'email',
        'description': 'description',
        'resources': 'resources',
        'links': 'links',
        'avatar_sha256': 'avatar_sha256',
        'avatar_url': 'avatar_url',
        'metadata_sha256': 'metadata_sha256'
    }

    def __init__(self, pulp_href=None, name=None, company=None, email=None, description=None, resources=None, links=None, avatar_sha256=None, avatar_url=None, metadata_sha256=None, local_vars_configuration=None):  # noqa: E501
        """AnsibleAnsibleNamespaceMetadataResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pulp_href = None
        self._name = None
        self._company = None
        self._email = None
        self._description = None
        self._resources = None
        self._links = None
        self._avatar_sha256 = None
        self._avatar_url = None
        self._metadata_sha256 = None
        self.discriminator = None

        if pulp_href is not None:
            self.pulp_href = pulp_href
        self.name = name
        if company is not None:
            self.company = company
        if email is not None:
            self.email = email
        if description is not None:
            self.description = description
        if resources is not None:
            self.resources = resources
        if links is not None:
            self.links = links
        if avatar_sha256 is not None:
            self.avatar_sha256 = avatar_sha256
        if avatar_url is not None:
            self.avatar_url = avatar_url
        if metadata_sha256 is not None:
            self.metadata_sha256 = metadata_sha256

    @property
    def pulp_href(self):
        """Gets the pulp_href of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501


        :return: The pulp_href of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._pulp_href

    @pulp_href.setter
    def pulp_href(self, pulp_href):
        """Sets the pulp_href of this AnsibleAnsibleNamespaceMetadataResponse.


        :param pulp_href: The pulp_href of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """

        self._pulp_href = pulp_href

    @property
    def name(self):
        """Gets the name of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501

        Required named, only accepts lowercase, numbers and underscores.  # noqa: E501

        :return: The name of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AnsibleAnsibleNamespaceMetadataResponse.

        Required named, only accepts lowercase, numbers and underscores.  # noqa: E501

        :param name: The name of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 3):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `3`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'^(?!.*__)[a-z]+[0-9a-z_]*$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^(?!.*__)[a-z]+[0-9a-z_]*$/`")  # noqa: E501

        self._name = name

    @property
    def company(self):
        """Gets the company of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501

        Optional namespace company owner.  # noqa: E501

        :return: The company of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._company

    @company.setter
    def company(self, company):
        """Sets the company of this AnsibleAnsibleNamespaceMetadataResponse.

        Optional namespace company owner.  # noqa: E501

        :param company: The company of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                company is not None and len(company) > 64):
            raise ValueError("Invalid value for `company`, length must be less than or equal to `64`")  # noqa: E501

        self._company = company

    @property
    def email(self):
        """Gets the email of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501

        Optional namespace contact email.  # noqa: E501

        :return: The email of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this AnsibleAnsibleNamespaceMetadataResponse.

        Optional namespace contact email.  # noqa: E501

        :param email: The email of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) > 256):
            raise ValueError("Invalid value for `email`, length must be less than or equal to `256`")  # noqa: E501

        self._email = email

    @property
    def description(self):
        """Gets the description of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501

        Optional short description.  # noqa: E501

        :return: The description of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AnsibleAnsibleNamespaceMetadataResponse.

        Optional short description.  # noqa: E501

        :param description: The description of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 256):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")  # noqa: E501

        self._description = description

    @property
    def resources(self):
        """Gets the resources of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501

        Optional resource page in markdown format.  # noqa: E501

        :return: The resources of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this AnsibleAnsibleNamespaceMetadataResponse.

        Optional resource page in markdown format.  # noqa: E501

        :param resources: The resources of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """

        self._resources = resources

    @property
    def links(self):
        """Gets the links of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501

        Labeled related links.  # noqa: E501

        :return: The links of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: list[NamespaceLinkResponse]
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this AnsibleAnsibleNamespaceMetadataResponse.

        Labeled related links.  # noqa: E501

        :param links: The links of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: list[NamespaceLinkResponse]
        """

        self._links = links

    @property
    def avatar_sha256(self):
        """Gets the avatar_sha256 of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501

        SHA256 digest of avatar image if present.  # noqa: E501

        :return: The avatar_sha256 of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._avatar_sha256

    @avatar_sha256.setter
    def avatar_sha256(self, avatar_sha256):
        """Sets the avatar_sha256 of this AnsibleAnsibleNamespaceMetadataResponse.

        SHA256 digest of avatar image if present.  # noqa: E501

        :param avatar_sha256: The avatar_sha256 of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                avatar_sha256 is not None and len(avatar_sha256) > 64):
            raise ValueError("Invalid value for `avatar_sha256`, length must be less than or equal to `64`")  # noqa: E501

        self._avatar_sha256 = avatar_sha256

    @property
    def avatar_url(self):
        """Gets the avatar_url of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501

        Download link for avatar image if present.  # noqa: E501

        :return: The avatar_url of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._avatar_url

    @avatar_url.setter
    def avatar_url(self, avatar_url):
        """Sets the avatar_url of this AnsibleAnsibleNamespaceMetadataResponse.

        Download link for avatar image if present.  # noqa: E501

        :param avatar_url: The avatar_url of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """

        self._avatar_url = avatar_url

    @property
    def metadata_sha256(self):
        """Gets the metadata_sha256 of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501


        :return: The metadata_sha256 of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._metadata_sha256

    @metadata_sha256.setter
    def metadata_sha256(self, metadata_sha256):
        """Sets the metadata_sha256 of this AnsibleAnsibleNamespaceMetadataResponse.


        :param metadata_sha256: The metadata_sha256 of this AnsibleAnsibleNamespaceMetadataResponse.  # noqa: E501
        :type: str
        """

        self._metadata_sha256 = metadata_sha256

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AnsibleAnsibleNamespaceMetadataResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AnsibleAnsibleNamespaceMetadataResponse):
            return True

        return self.to_dict() != other.to_dict()
