# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_ansible.configuration import Configuration


class AnsibleAnsibleNamespaceMetadata(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'company': 'str',
        'email': 'str',
        'description': 'str',
        'resources': 'str',
        'links': 'list[NamespaceLink]',
        'avatar': 'file'
    }

    attribute_map = {
        'name': 'name',
        'company': 'company',
        'email': 'email',
        'description': 'description',
        'resources': 'resources',
        'links': 'links',
        'avatar': 'avatar'
    }

    def __init__(self, name=None, company=None, email=None, description=None, resources=None, links=None, avatar=None, local_vars_configuration=None):  # noqa: E501
        """AnsibleAnsibleNamespaceMetadata - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._company = None
        self._email = None
        self._description = None
        self._resources = None
        self._links = None
        self._avatar = None
        self.discriminator = None

        self.name = name
        if company is not None:
            self.company = company
        if email is not None:
            self.email = email
        if description is not None:
            self.description = description
        if resources is not None:
            self.resources = resources
        if links is not None:
            self.links = links
        if avatar is not None:
            self.avatar = avatar

    @property
    def name(self):
        """Gets the name of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501

        Required named, only accepts lowercase, numbers and underscores.  # noqa: E501

        :return: The name of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AnsibleAnsibleNamespaceMetadata.

        Required named, only accepts lowercase, numbers and underscores.  # noqa: E501

        :param name: The name of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 3):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `3`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'^(?!.*__)[a-z]+[0-9a-z_]*$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^(?!.*__)[a-z]+[0-9a-z_]*$/`")  # noqa: E501

        self._name = name

    @property
    def company(self):
        """Gets the company of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501

        Optional namespace company owner.  # noqa: E501

        :return: The company of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :rtype: str
        """
        return self._company

    @company.setter
    def company(self, company):
        """Sets the company of this AnsibleAnsibleNamespaceMetadata.

        Optional namespace company owner.  # noqa: E501

        :param company: The company of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                company is not None and len(company) > 64):
            raise ValueError("Invalid value for `company`, length must be less than or equal to `64`")  # noqa: E501

        self._company = company

    @property
    def email(self):
        """Gets the email of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501

        Optional namespace contact email.  # noqa: E501

        :return: The email of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this AnsibleAnsibleNamespaceMetadata.

        Optional namespace contact email.  # noqa: E501

        :param email: The email of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) > 256):
            raise ValueError("Invalid value for `email`, length must be less than or equal to `256`")  # noqa: E501

        self._email = email

    @property
    def description(self):
        """Gets the description of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501

        Optional short description.  # noqa: E501

        :return: The description of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AnsibleAnsibleNamespaceMetadata.

        Optional short description.  # noqa: E501

        :param description: The description of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 256):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")  # noqa: E501

        self._description = description

    @property
    def resources(self):
        """Gets the resources of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501

        Optional resource page in markdown format.  # noqa: E501

        :return: The resources of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :rtype: str
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this AnsibleAnsibleNamespaceMetadata.

        Optional resource page in markdown format.  # noqa: E501

        :param resources: The resources of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :type: str
        """

        self._resources = resources

    @property
    def links(self):
        """Gets the links of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501

        Labeled related links.  # noqa: E501

        :return: The links of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :rtype: list[NamespaceLink]
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this AnsibleAnsibleNamespaceMetadata.

        Labeled related links.  # noqa: E501

        :param links: The links of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :type: list[NamespaceLink]
        """

        self._links = links

    @property
    def avatar(self):
        """Gets the avatar of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501

        Optional avatar image for Namespace  # noqa: E501

        :return: The avatar of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :rtype: file
        """
        return self._avatar

    @avatar.setter
    def avatar(self, avatar):
        """Sets the avatar of this AnsibleAnsibleNamespaceMetadata.

        Optional avatar image for Namespace  # noqa: E501

        :param avatar: The avatar of this AnsibleAnsibleNamespaceMetadata.  # noqa: E501
        :type: file
        """

        self._avatar = avatar

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AnsibleAnsibleNamespaceMetadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AnsibleAnsibleNamespaceMetadata):
            return True

        return self.to_dict() != other.to_dict()
