# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_ansible.api_client import ApiClient
from pulpcore.client.pulp_ansible.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RemotesRoleApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_role(self, ansible_role_remote_href, nested_role,  **kwargs):  # noqa: E501
        """add_role  # noqa: E501

        Add a role for this object to users/groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role(ansible_role_remote_href, nested_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param NestedRole nested_role: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NestedRoleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_role_with_http_info(ansible_role_remote_href, nested_role,  **kwargs)  # noqa: E501

    def add_role_with_http_info(self, ansible_role_remote_href, nested_role,  **kwargs):  # noqa: E501
        """add_role  # noqa: E501

        Add a role for this object to users/groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_with_http_info(ansible_role_remote_href, nested_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param NestedRole nested_role: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NestedRoleResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote_href',
            'nested_role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote_href' is set
        if self.api_client.client_side_validation and ('ansible_role_remote_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote_href` when calling `add_role`")  # noqa: E501
        # verify the required parameter 'nested_role' is set
        if self.api_client.client_side_validation and ('nested_role' not in local_var_params or  # noqa: E501
                                                        local_var_params['nested_role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `nested_role` when calling `add_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ansible_role_remote_href' in local_var_params:
            path_params['ansible_role_remote_href'] = local_var_params['ansible_role_remote_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nested_role' in local_var_params:
            body_params = local_var_params['nested_role']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{ansible_role_remote_href}add_role/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NestedRoleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create(self, ansible_role_remote,  **kwargs):  # noqa: E501
        """Create a role remote  # noqa: E501

        ViewSet for Role Remotes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(ansible_role_remote, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AnsibleRoleRemote ansible_role_remote: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AnsibleRoleRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_with_http_info(ansible_role_remote,  **kwargs)  # noqa: E501

    def create_with_http_info(self, ansible_role_remote,  **kwargs):  # noqa: E501
        """Create a role remote  # noqa: E501

        ViewSet for Role Remotes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(ansible_role_remote, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AnsibleRoleRemote ansible_role_remote: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AnsibleRoleRemoteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote' is set
        if self.api_client.client_side_validation and ('ansible_role_remote' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ansible_role_remote' in local_var_params:
            body_params = local_var_params['ansible_role_remote']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/remotes/ansible/role/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnsibleRoleRemoteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, ansible_role_remote_href,  **kwargs):  # noqa: E501
        """Delete a role remote  # noqa: E501

        Trigger an asynchronous delete task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(ansible_role_remote_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_with_http_info(ansible_role_remote_href,  **kwargs)  # noqa: E501

    def delete_with_http_info(self, ansible_role_remote_href,  **kwargs):  # noqa: E501
        """Delete a role remote  # noqa: E501

        Trigger an asynchronous delete task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(ansible_role_remote_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote_href'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote_href' is set
        if self.api_client.client_side_validation and ('ansible_role_remote_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote_href` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ansible_role_remote_href' in local_var_params:
            path_params['ansible_role_remote_href'] = local_var_params['ansible_role_remote_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{ansible_role_remote_href}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self,  **kwargs):  # noqa: E501
        """List role remotes  # noqa: E501

        ViewSet for Role Remotes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param str name: Filter results where name matches value
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param list[str] ordering: Ordering
        :param str pulp_label_select: Filter labels by search string
        :param datetime pulp_last_updated: Filter results where pulp_last_updated matches value
        :param datetime pulp_last_updated__gt: Filter results where pulp_last_updated is greater than value
        :param datetime pulp_last_updated__gte: Filter results where pulp_last_updated is greater than or equal to value
        :param datetime pulp_last_updated__lt: Filter results where pulp_last_updated is less than value
        :param datetime pulp_last_updated__lte: Filter results where pulp_last_updated is less than or equal to value
        :param list[datetime] pulp_last_updated__range: Filter results where pulp_last_updated is between two comma separated values
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedansibleRoleRemoteResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info( **kwargs)  # noqa: E501

    def list_with_http_info(self,  **kwargs):  # noqa: E501
        """List role remotes  # noqa: E501

        ViewSet for Role Remotes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param str name: Filter results where name matches value
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param list[str] ordering: Ordering
        :param str pulp_label_select: Filter labels by search string
        :param datetime pulp_last_updated: Filter results where pulp_last_updated matches value
        :param datetime pulp_last_updated__gt: Filter results where pulp_last_updated is greater than value
        :param datetime pulp_last_updated__gte: Filter results where pulp_last_updated is greater than or equal to value
        :param datetime pulp_last_updated__lt: Filter results where pulp_last_updated is less than value
        :param datetime pulp_last_updated__lte: Filter results where pulp_last_updated is less than or equal to value
        :param list[datetime] pulp_last_updated__range: Filter results where pulp_last_updated is between two comma separated values
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedansibleRoleRemoteResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'name',
            'name__contains',
            'name__icontains',
            'name__in',
            'name__startswith',
            'offset',
            'ordering',
            'pulp_label_select',
            'pulp_last_updated',
            'pulp_last_updated__gt',
            'pulp_last_updated__gte',
            'pulp_last_updated__lt',
            'pulp_last_updated__lte',
            'pulp_last_updated__range',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'name__icontains' in local_var_params and local_var_params['name__icontains'] is not None:  # noqa: E501
            query_params.append(('name__icontains', local_var_params['name__icontains']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
            collection_formats['name__in'] = 'csv'  # noqa: E501
        if 'name__startswith' in local_var_params and local_var_params['name__startswith'] is not None:  # noqa: E501
            query_params.append(('name__startswith', local_var_params['name__startswith']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'ordering' in local_var_params and local_var_params['ordering'] is not None:  # noqa: E501
            query_params.append(('ordering', local_var_params['ordering']))  # noqa: E501
            collection_formats['ordering'] = 'csv'  # noqa: E501
        if 'pulp_label_select' in local_var_params and local_var_params['pulp_label_select'] is not None:  # noqa: E501
            query_params.append(('pulp_label_select', local_var_params['pulp_label_select']))  # noqa: E501
        if 'pulp_last_updated' in local_var_params and local_var_params['pulp_last_updated'] is not None:  # noqa: E501
            query_params.append(('pulp_last_updated', local_var_params['pulp_last_updated']))  # noqa: E501
        if 'pulp_last_updated__gt' in local_var_params and local_var_params['pulp_last_updated__gt'] is not None:  # noqa: E501
            query_params.append(('pulp_last_updated__gt', local_var_params['pulp_last_updated__gt']))  # noqa: E501
        if 'pulp_last_updated__gte' in local_var_params and local_var_params['pulp_last_updated__gte'] is not None:  # noqa: E501
            query_params.append(('pulp_last_updated__gte', local_var_params['pulp_last_updated__gte']))  # noqa: E501
        if 'pulp_last_updated__lt' in local_var_params and local_var_params['pulp_last_updated__lt'] is not None:  # noqa: E501
            query_params.append(('pulp_last_updated__lt', local_var_params['pulp_last_updated__lt']))  # noqa: E501
        if 'pulp_last_updated__lte' in local_var_params and local_var_params['pulp_last_updated__lte'] is not None:  # noqa: E501
            query_params.append(('pulp_last_updated__lte', local_var_params['pulp_last_updated__lte']))  # noqa: E501
        if 'pulp_last_updated__range' in local_var_params and local_var_params['pulp_last_updated__range'] is not None:  # noqa: E501
            query_params.append(('pulp_last_updated__range', local_var_params['pulp_last_updated__range']))  # noqa: E501
            collection_formats['pulp_last_updated__range'] = 'csv'  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/remotes/ansible/role/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedansibleRoleRemoteResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_roles(self, ansible_role_remote_href,  **kwargs):  # noqa: E501
        """list_roles  # noqa: E501

        List roles assigned to this object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_roles(ansible_role_remote_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ObjectRolesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_roles_with_http_info(ansible_role_remote_href,  **kwargs)  # noqa: E501

    def list_roles_with_http_info(self, ansible_role_remote_href,  **kwargs):  # noqa: E501
        """list_roles  # noqa: E501

        List roles assigned to this object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_roles_with_http_info(ansible_role_remote_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ObjectRolesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_roles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote_href' is set
        if self.api_client.client_side_validation and ('ansible_role_remote_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote_href` when calling `list_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ansible_role_remote_href' in local_var_params:
            path_params['ansible_role_remote_href'] = local_var_params['ansible_role_remote_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{ansible_role_remote_href}list_roles/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ObjectRolesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def my_permissions(self, ansible_role_remote_href,  **kwargs):  # noqa: E501
        """my_permissions  # noqa: E501

        List permissions available to the current user on this object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.my_permissions(ansible_role_remote_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MyPermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.my_permissions_with_http_info(ansible_role_remote_href,  **kwargs)  # noqa: E501

    def my_permissions_with_http_info(self, ansible_role_remote_href,  **kwargs):  # noqa: E501
        """my_permissions  # noqa: E501

        List permissions available to the current user on this object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.my_permissions_with_http_info(ansible_role_remote_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MyPermissionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method my_permissions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote_href' is set
        if self.api_client.client_side_validation and ('ansible_role_remote_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote_href` when calling `my_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ansible_role_remote_href' in local_var_params:
            path_params['ansible_role_remote_href'] = local_var_params['ansible_role_remote_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{ansible_role_remote_href}my_permissions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MyPermissionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update(self, ansible_role_remote_href, patchedansible_role_remote,  **kwargs):  # noqa: E501
        """Update a role remote  # noqa: E501

        Trigger an asynchronous partial update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update(ansible_role_remote_href, patchedansible_role_remote, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param PatchedansibleRoleRemote patchedansible_role_remote: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_with_http_info(ansible_role_remote_href, patchedansible_role_remote,  **kwargs)  # noqa: E501

    def partial_update_with_http_info(self, ansible_role_remote_href, patchedansible_role_remote,  **kwargs):  # noqa: E501
        """Update a role remote  # noqa: E501

        Trigger an asynchronous partial update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_with_http_info(ansible_role_remote_href, patchedansible_role_remote, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param PatchedansibleRoleRemote patchedansible_role_remote: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote_href',
            'patchedansible_role_remote'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote_href' is set
        if self.api_client.client_side_validation and ('ansible_role_remote_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote_href` when calling `partial_update`")  # noqa: E501
        # verify the required parameter 'patchedansible_role_remote' is set
        if self.api_client.client_side_validation and ('patchedansible_role_remote' not in local_var_params or  # noqa: E501
                                                        local_var_params['patchedansible_role_remote'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patchedansible_role_remote` when calling `partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ansible_role_remote_href' in local_var_params:
            path_params['ansible_role_remote_href'] = local_var_params['ansible_role_remote_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patchedansible_role_remote' in local_var_params:
            body_params = local_var_params['patchedansible_role_remote']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{ansible_role_remote_href}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, ansible_role_remote_href,  **kwargs):  # noqa: E501
        """Inspect a role remote  # noqa: E501

        ViewSet for Role Remotes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(ansible_role_remote_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AnsibleRoleRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(ansible_role_remote_href,  **kwargs)  # noqa: E501

    def read_with_http_info(self, ansible_role_remote_href,  **kwargs):  # noqa: E501
        """Inspect a role remote  # noqa: E501

        ViewSet for Role Remotes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(ansible_role_remote_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AnsibleRoleRemoteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote_href' is set
        if self.api_client.client_side_validation and ('ansible_role_remote_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote_href` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ansible_role_remote_href' in local_var_params:
            path_params['ansible_role_remote_href'] = local_var_params['ansible_role_remote_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{ansible_role_remote_href}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnsibleRoleRemoteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_role(self, ansible_role_remote_href, nested_role,  **kwargs):  # noqa: E501
        """remove_role  # noqa: E501

        Remove a role for this object from users/groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_role(ansible_role_remote_href, nested_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param NestedRole nested_role: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NestedRoleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_role_with_http_info(ansible_role_remote_href, nested_role,  **kwargs)  # noqa: E501

    def remove_role_with_http_info(self, ansible_role_remote_href, nested_role,  **kwargs):  # noqa: E501
        """remove_role  # noqa: E501

        Remove a role for this object from users/groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_role_with_http_info(ansible_role_remote_href, nested_role, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param NestedRole nested_role: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NestedRoleResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote_href',
            'nested_role'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote_href' is set
        if self.api_client.client_side_validation and ('ansible_role_remote_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote_href` when calling `remove_role`")  # noqa: E501
        # verify the required parameter 'nested_role' is set
        if self.api_client.client_side_validation and ('nested_role' not in local_var_params or  # noqa: E501
                                                        local_var_params['nested_role'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `nested_role` when calling `remove_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ansible_role_remote_href' in local_var_params:
            path_params['ansible_role_remote_href'] = local_var_params['ansible_role_remote_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nested_role' in local_var_params:
            body_params = local_var_params['nested_role']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{ansible_role_remote_href}remove_role/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NestedRoleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, ansible_role_remote_href, ansible_role_remote,  **kwargs):  # noqa: E501
        """Update a role remote  # noqa: E501

        Trigger an asynchronous update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(ansible_role_remote_href, ansible_role_remote, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param AnsibleRoleRemote ansible_role_remote: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_with_http_info(ansible_role_remote_href, ansible_role_remote,  **kwargs)  # noqa: E501

    def update_with_http_info(self, ansible_role_remote_href, ansible_role_remote,  **kwargs):  # noqa: E501
        """Update a role remote  # noqa: E501

        Trigger an asynchronous update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(ansible_role_remote_href, ansible_role_remote, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ansible_role_remote_href: (required)
        :param AnsibleRoleRemote ansible_role_remote: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'ansible_role_remote_href',
            'ansible_role_remote'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ansible_role_remote_href' is set
        if self.api_client.client_side_validation and ('ansible_role_remote_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote_href` when calling `update`")  # noqa: E501
        # verify the required parameter 'ansible_role_remote' is set
        if self.api_client.client_side_validation and ('ansible_role_remote' not in local_var_params or  # noqa: E501
                                                        local_var_params['ansible_role_remote'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ansible_role_remote` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ansible_role_remote_href' in local_var_params:
            path_params['ansible_role_remote_href'] = local_var_params['ansible_role_remote_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ansible_role_remote' in local_var_params:
            body_params = local_var_params['ansible_role_remote']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{ansible_role_remote_href}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
