# pulp_ansible-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.17.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_ansible
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_ansible
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_ansible
from pulpcore.client.pulp_ansible.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_ansible.Configuration(
    host = "https://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_ansible.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_ansible.Configuration(
    host = "https://pulp",
    api_key = {
        'sessionid': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionid'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_ansible.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_ansible.AnsibleCollectionsApi(api_client)
    ansible_collection_href = 'ansible_collection_href_example' # str | 
nested_role = pulpcore.client.pulp_ansible.NestedRole() # NestedRole | 

    try:
        api_response = api_instance.add_role(ansible_collection_href, nested_role)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AnsibleCollectionsApi->add_role: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnsibleCollectionsApi* | [**add_role**](docs/AnsibleCollectionsApi.md#add_role) | **POST** {ansible_collection_href}add_role/ | 
*AnsibleCollectionsApi* | [**list**](docs/AnsibleCollectionsApi.md#list) | **GET** /pulp/api/v3/ansible/collections/ | List collections
*AnsibleCollectionsApi* | [**list_roles**](docs/AnsibleCollectionsApi.md#list_roles) | **GET** {ansible_collection_href}list_roles/ | 
*AnsibleCollectionsApi* | [**my_permissions**](docs/AnsibleCollectionsApi.md#my_permissions) | **GET** {ansible_collection_href}my_permissions/ | 
*AnsibleCollectionsApi* | [**remove_role**](docs/AnsibleCollectionsApi.md#remove_role) | **POST** {ansible_collection_href}remove_role/ | 
*AnsibleCollectionsApi* | [**upload_collection**](docs/AnsibleCollectionsApi.md#upload_collection) | **POST** /ansible/collections/ | Upload a collection
*AnsibleCopyApi* | [**copy_content**](docs/AnsibleCopyApi.md#copy_content) | **POST** /pulp/api/v3/ansible/copy/ | Copy content
*ApiCollectionsApi* | [**get**](docs/ApiCollectionsApi.md#get) | **GET** {ansible_collection_href}api/v2/collections/ | 
*ApiCollectionsApi* | [**post**](docs/ApiCollectionsApi.md#post) | **POST** {ansible_collection_href}api/v2/collections/ | 
*ApiRolesApi* | [**get**](docs/ApiRolesApi.md#get) | **GET** {ansible_role_href}api/v1/roles/ | 
*CollectionImportApi* | [**read**](docs/CollectionImportApi.md#read) | **GET** {ansible_collection_import_href} | Inspect a collection import
*ContentCollectionDeprecationsApi* | [**create**](docs/ContentCollectionDeprecationsApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_deprecations/ | Create an ansible collection deprecated
*ContentCollectionDeprecationsApi* | [**list**](docs/ContentCollectionDeprecationsApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_deprecations/ | List ansible collection deprecateds
*ContentCollectionDeprecationsApi* | [**read**](docs/ContentCollectionDeprecationsApi.md#read) | **GET** {ansible_ansible_collection_deprecated_href} | Inspect an ansible collection deprecated
*ContentCollectionMarksApi* | [**create**](docs/ContentCollectionMarksApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_marks/ | Create a collection version mark
*ContentCollectionMarksApi* | [**list**](docs/ContentCollectionMarksApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_marks/ | List collection version marks
*ContentCollectionMarksApi* | [**read**](docs/ContentCollectionMarksApi.md#read) | **GET** {ansible_collection_version_mark_href} | Inspect a collection version mark
*ContentCollectionSignaturesApi* | [**create**](docs/ContentCollectionSignaturesApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_signatures/ | Create a collection version signature
*ContentCollectionSignaturesApi* | [**list**](docs/ContentCollectionSignaturesApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_signatures/ | List collection version signatures
*ContentCollectionSignaturesApi* | [**read**](docs/ContentCollectionSignaturesApi.md#read) | **GET** {ansible_collection_version_signature_href} | Inspect a collection version signature
*ContentCollectionVersionsApi* | [**create**](docs/ContentCollectionVersionsApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_versions/ | Create a collection version
*ContentCollectionVersionsApi* | [**list**](docs/ContentCollectionVersionsApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_versions/ | List collection versions
*ContentCollectionVersionsApi* | [**read**](docs/ContentCollectionVersionsApi.md#read) | **GET** {ansible_collection_version_href} | Inspect a collection version
*ContentNamespacesApi* | [**avatar**](docs/ContentNamespacesApi.md#avatar) | **GET** {ansible_ansible_namespace_metadata_href}avatar/ | 
*ContentNamespacesApi* | [**list**](docs/ContentNamespacesApi.md#list) | **GET** /pulp/api/v3/content/ansible/namespaces/ | List ansible namespace metadatas
*ContentNamespacesApi* | [**read**](docs/ContentNamespacesApi.md#read) | **GET** {ansible_ansible_namespace_metadata_href} | Inspect an ansible namespace metadata
*ContentRolesApi* | [**create**](docs/ContentRolesApi.md#create) | **POST** /pulp/api/v3/content/ansible/roles/ | Create a role
*ContentRolesApi* | [**list**](docs/ContentRolesApi.md#list) | **GET** /pulp/api/v3/content/ansible/roles/ | List roles
*ContentRolesApi* | [**read**](docs/ContentRolesApi.md#read) | **GET** {ansible_role_href} | Inspect a role
*DistributionsAnsibleApi* | [**add_role**](docs/DistributionsAnsibleApi.md#add_role) | **POST** {ansible_ansible_distribution_href}add_role/ | 
*DistributionsAnsibleApi* | [**create**](docs/DistributionsAnsibleApi.md#create) | **POST** /pulp/api/v3/distributions/ansible/ansible/ | Create an ansible distribution
*DistributionsAnsibleApi* | [**delete**](docs/DistributionsAnsibleApi.md#delete) | **DELETE** {ansible_ansible_distribution_href} | Delete an ansible distribution
*DistributionsAnsibleApi* | [**list**](docs/DistributionsAnsibleApi.md#list) | **GET** /pulp/api/v3/distributions/ansible/ansible/ | List ansible distributions
*DistributionsAnsibleApi* | [**list_roles**](docs/DistributionsAnsibleApi.md#list_roles) | **GET** {ansible_ansible_distribution_href}list_roles/ | 
*DistributionsAnsibleApi* | [**my_permissions**](docs/DistributionsAnsibleApi.md#my_permissions) | **GET** {ansible_ansible_distribution_href}my_permissions/ | 
*DistributionsAnsibleApi* | [**partial_update**](docs/DistributionsAnsibleApi.md#partial_update) | **PATCH** {ansible_ansible_distribution_href} | Update an ansible distribution
*DistributionsAnsibleApi* | [**read**](docs/DistributionsAnsibleApi.md#read) | **GET** {ansible_ansible_distribution_href} | Inspect an ansible distribution
*DistributionsAnsibleApi* | [**remove_role**](docs/DistributionsAnsibleApi.md#remove_role) | **POST** {ansible_ansible_distribution_href}remove_role/ | 
*DistributionsAnsibleApi* | [**update**](docs/DistributionsAnsibleApi.md#update) | **PUT** {ansible_ansible_distribution_href} | Update an ansible distribution
*GalaxyDetailApi* | [**get**](docs/GalaxyDetailApi.md#get) | **GET** {ansible_collection_href} | 
*PulpAnsibleApiApi* | [**get**](docs/PulpAnsibleApiApi.md#get) | **GET** /pulp_ansible/galaxy/{path}/api/ | 
*PulpAnsibleApiV2CollectionsVersionsApi* | [**get**](docs/PulpAnsibleApiV2CollectionsVersionsApi.md#get) | **GET** /pulp_ansible/galaxy/{path}/api/v2/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3Api* | [**read**](docs/PulpAnsibleApiV3Api.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/ | 
*PulpAnsibleApiV3ArtifactsCollectionsApi* | [**get**](docs/PulpAnsibleApiV3ArtifactsCollectionsApi.md#get) | **GET** /pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/{path}/{filename} | 
*PulpAnsibleApiV3CollectionVersionsAllApi* | [**list**](docs/PulpAnsibleApiV3CollectionVersionsAllApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collection_versions/all/ | 
*PulpAnsibleApiV3CollectionsApi* | [**delete**](docs/PulpAnsibleApiV3CollectionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsApi* | [**list**](docs/PulpAnsibleApiV3CollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/ | 
*PulpAnsibleApiV3CollectionsApi* | [**read**](docs/PulpAnsibleApiV3CollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsApi* | [**update**](docs/PulpAnsibleApiV3CollectionsApi.md#update) | **PATCH** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleApiV3CollectionsAllApi* | [**list**](docs/PulpAnsibleApiV3CollectionsAllApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/all/ | 
*PulpAnsibleApiV3CollectionsVersionsApi* | [**delete**](docs/PulpAnsibleApiV3CollectionsVersionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3CollectionsVersionsApi* | [**list**](docs/PulpAnsibleApiV3CollectionsVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/ | 
*PulpAnsibleApiV3CollectionsVersionsApi* | [**read**](docs/PulpAnsibleApiV3CollectionsVersionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3CollectionsVersionsDocsBlobApi* | [**read**](docs/PulpAnsibleApiV3CollectionsVersionsDocsBlobApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleApiV3NamespacesApi* | [**list**](docs/PulpAnsibleApiV3NamespacesApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/namespaces/ | 
*PulpAnsibleApiV3NamespacesApi* | [**read**](docs/PulpAnsibleApiV3NamespacesApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/namespaces/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleClientConfigurationApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleClientConfigurationApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/client-configuration/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsAllCollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-collections/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsAllVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-versions/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsApi* | [**download**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsArtifactsApi.md#download) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/{filename} | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi* | [**delete**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi* | [**update**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexApi.md#update) | **PATCH** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**delete**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesApi* | [**create**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesApi.md#create) | **POST** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesApi* | [**delete**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesApi.md#delete) | **DELETE** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesApi* | [**partial_update**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesApi.md#partial_update) | **PATCH** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleContentNamespacesApi* | [**read**](docs/PulpAnsibleApiV3PluginAnsibleContentNamespacesApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsApi* | [**list**](docs/PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/search/collection-versions/ | 
*PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsApi* | [**rebuild**](docs/PulpAnsibleApiV3PluginAnsibleSearchCollectionVersionsApi.md#rebuild) | **POST** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/search/collection-versions/ | 
*PulpAnsibleArtifactsCollectionsV3Api* | [**create**](docs/PulpAnsibleArtifactsCollectionsV3Api.md#create) | **POST** /pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3Api* | [**create_0**](docs/PulpAnsibleArtifactsCollectionsV3Api.md#create_0) | **POST** /pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3Api* | [**create_1**](docs/PulpAnsibleArtifactsCollectionsV3Api.md#create_1) | **POST** /pulp_ansible/galaxy/default/api/v3/artifacts/collections/ | Upload a collection
*PulpAnsibleArtifactsCollectionsV3Api* | [**create_2**](docs/PulpAnsibleArtifactsCollectionsV3Api.md#create_2) | **POST** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/ | Upload a collection
*PulpAnsibleDefaultApiApi* | [**get**](docs/PulpAnsibleDefaultApiApi.md#get) | **GET** /pulp_ansible/galaxy/default/api/ | 
*PulpAnsibleDefaultApiV3Api* | [**read**](docs/PulpAnsibleDefaultApiV3Api.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/ | 
*PulpAnsibleDefaultApiV3ArtifactsCollectionsApi* | [**get**](docs/PulpAnsibleDefaultApiV3ArtifactsCollectionsApi.md#get) | **GET** /pulp_ansible/galaxy/default/api/v3/artifacts/collections/{path}/{filename} | 
*PulpAnsibleDefaultApiV3CollectionVersionsAllApi* | [**list**](docs/PulpAnsibleDefaultApiV3CollectionVersionsAllApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/collection_versions/all/ | 
*PulpAnsibleDefaultApiV3CollectionsApi* | [**delete**](docs/PulpAnsibleDefaultApiV3CollectionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3CollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/ | 
*PulpAnsibleDefaultApiV3CollectionsApi* | [**read**](docs/PulpAnsibleDefaultApiV3CollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsApi* | [**update**](docs/PulpAnsibleDefaultApiV3CollectionsApi.md#update) | **PATCH** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3CollectionsAllApi* | [**list**](docs/PulpAnsibleDefaultApiV3CollectionsAllApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/all/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsApi* | [**delete**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsApi* | [**read**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobApi* | [**read**](docs/PulpAnsibleDefaultApiV3CollectionsVersionsDocsBlobApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleDefaultApiV3NamespacesApi* | [**list**](docs/PulpAnsibleDefaultApiV3NamespacesApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/namespaces/ | 
*PulpAnsibleDefaultApiV3NamespacesApi* | [**read**](docs/PulpAnsibleDefaultApiV3NamespacesApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/namespaces/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/client-configuration/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-collections/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-versions/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsApi* | [**download**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsArtifactsApi.md#download) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/{filename} | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi* | [**delete**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi* | [**update**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexApi.md#update) | **PATCH** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**delete**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsIndexVersionsDocsBlobApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/index/{namespace}/{name}/versions/{version}/docs-blob/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi* | [**create**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi.md#create) | **POST** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi* | [**delete**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi.md#delete) | **DELETE** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi* | [**partial_update**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi.md#partial_update) | **PATCH** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi* | [**read**](docs/PulpAnsibleDefaultApiV3PluginAnsibleContentNamespacesApi.md#read) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/namespaces/{name}/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsApi* | [**list**](docs/PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsApi.md#list) | **GET** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/search/collection-versions/ | 
*PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsApi* | [**rebuild**](docs/PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsApi.md#rebuild) | **POST** /pulp_ansible/galaxy/default/api/v3/plugin/ansible/search/collection-versions/ | 
*PulpAnsibleTagsApi* | [**list**](docs/PulpAnsibleTagsApi.md#list) | **GET** /pulp/api/v3/pulp_ansible/tags/ | List tags
*RemotesCollectionApi* | [**add_role**](docs/RemotesCollectionApi.md#add_role) | **POST** {ansible_collection_remote_href}add_role/ | 
*RemotesCollectionApi* | [**create**](docs/RemotesCollectionApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/collection/ | Create a collection remote
*RemotesCollectionApi* | [**delete**](docs/RemotesCollectionApi.md#delete) | **DELETE** {ansible_collection_remote_href} | Delete a collection remote
*RemotesCollectionApi* | [**list**](docs/RemotesCollectionApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/collection/ | List collection remotes
*RemotesCollectionApi* | [**list_roles**](docs/RemotesCollectionApi.md#list_roles) | **GET** {ansible_collection_remote_href}list_roles/ | 
*RemotesCollectionApi* | [**my_permissions**](docs/RemotesCollectionApi.md#my_permissions) | **GET** {ansible_collection_remote_href}my_permissions/ | 
*RemotesCollectionApi* | [**partial_update**](docs/RemotesCollectionApi.md#partial_update) | **PATCH** {ansible_collection_remote_href} | Update a collection remote
*RemotesCollectionApi* | [**read**](docs/RemotesCollectionApi.md#read) | **GET** {ansible_collection_remote_href} | Inspect a collection remote
*RemotesCollectionApi* | [**remove_role**](docs/RemotesCollectionApi.md#remove_role) | **POST** {ansible_collection_remote_href}remove_role/ | 
*RemotesCollectionApi* | [**update**](docs/RemotesCollectionApi.md#update) | **PUT** {ansible_collection_remote_href} | Update a collection remote
*RemotesGitApi* | [**add_role**](docs/RemotesGitApi.md#add_role) | **POST** {ansible_git_remote_href}add_role/ | 
*RemotesGitApi* | [**create**](docs/RemotesGitApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/git/ | Create a git remote
*RemotesGitApi* | [**delete**](docs/RemotesGitApi.md#delete) | **DELETE** {ansible_git_remote_href} | Delete a git remote
*RemotesGitApi* | [**list**](docs/RemotesGitApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/git/ | List git remotes
*RemotesGitApi* | [**list_roles**](docs/RemotesGitApi.md#list_roles) | **GET** {ansible_git_remote_href}list_roles/ | 
*RemotesGitApi* | [**my_permissions**](docs/RemotesGitApi.md#my_permissions) | **GET** {ansible_git_remote_href}my_permissions/ | 
*RemotesGitApi* | [**partial_update**](docs/RemotesGitApi.md#partial_update) | **PATCH** {ansible_git_remote_href} | Update a git remote
*RemotesGitApi* | [**read**](docs/RemotesGitApi.md#read) | **GET** {ansible_git_remote_href} | Inspect a git remote
*RemotesGitApi* | [**remove_role**](docs/RemotesGitApi.md#remove_role) | **POST** {ansible_git_remote_href}remove_role/ | 
*RemotesGitApi* | [**update**](docs/RemotesGitApi.md#update) | **PUT** {ansible_git_remote_href} | Update a git remote
*RemotesRoleApi* | [**add_role**](docs/RemotesRoleApi.md#add_role) | **POST** {ansible_role_remote_href}add_role/ | 
*RemotesRoleApi* | [**create**](docs/RemotesRoleApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/role/ | Create a role remote
*RemotesRoleApi* | [**delete**](docs/RemotesRoleApi.md#delete) | **DELETE** {ansible_role_remote_href} | Delete a role remote
*RemotesRoleApi* | [**list**](docs/RemotesRoleApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/role/ | List role remotes
*RemotesRoleApi* | [**list_roles**](docs/RemotesRoleApi.md#list_roles) | **GET** {ansible_role_remote_href}list_roles/ | 
*RemotesRoleApi* | [**my_permissions**](docs/RemotesRoleApi.md#my_permissions) | **GET** {ansible_role_remote_href}my_permissions/ | 
*RemotesRoleApi* | [**partial_update**](docs/RemotesRoleApi.md#partial_update) | **PATCH** {ansible_role_remote_href} | Update a role remote
*RemotesRoleApi* | [**read**](docs/RemotesRoleApi.md#read) | **GET** {ansible_role_remote_href} | Inspect a role remote
*RemotesRoleApi* | [**remove_role**](docs/RemotesRoleApi.md#remove_role) | **POST** {ansible_role_remote_href}remove_role/ | 
*RemotesRoleApi* | [**update**](docs/RemotesRoleApi.md#update) | **PUT** {ansible_role_remote_href} | Update a role remote
*RepositoriesAnsibleApi* | [**add_role**](docs/RepositoriesAnsibleApi.md#add_role) | **POST** {ansible_ansible_repository_href}add_role/ | 
*RepositoriesAnsibleApi* | [**copy_collection_version**](docs/RepositoriesAnsibleApi.md#copy_collection_version) | **POST** {ansible_ansible_repository_href}copy_collection_version/ | 
*RepositoriesAnsibleApi* | [**create**](docs/RepositoriesAnsibleApi.md#create) | **POST** /pulp/api/v3/repositories/ansible/ansible/ | Create an ansible repository
*RepositoriesAnsibleApi* | [**delete**](docs/RepositoriesAnsibleApi.md#delete) | **DELETE** {ansible_ansible_repository_href} | Delete an ansible repository
*RepositoriesAnsibleApi* | [**list**](docs/RepositoriesAnsibleApi.md#list) | **GET** /pulp/api/v3/repositories/ansible/ansible/ | List ansible repositorys
*RepositoriesAnsibleApi* | [**list_roles**](docs/RepositoriesAnsibleApi.md#list_roles) | **GET** {ansible_ansible_repository_href}list_roles/ | 
*RepositoriesAnsibleApi* | [**mark**](docs/RepositoriesAnsibleApi.md#mark) | **POST** {ansible_ansible_repository_href}mark/ | 
*RepositoriesAnsibleApi* | [**modify**](docs/RepositoriesAnsibleApi.md#modify) | **POST** {ansible_ansible_repository_href}modify/ | Modify Repository Content
*RepositoriesAnsibleApi* | [**move_collection_version**](docs/RepositoriesAnsibleApi.md#move_collection_version) | **POST** {ansible_ansible_repository_href}move_collection_version/ | 
*RepositoriesAnsibleApi* | [**my_permissions**](docs/RepositoriesAnsibleApi.md#my_permissions) | **GET** {ansible_ansible_repository_href}my_permissions/ | 
*RepositoriesAnsibleApi* | [**partial_update**](docs/RepositoriesAnsibleApi.md#partial_update) | **PATCH** {ansible_ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleApi* | [**read**](docs/RepositoriesAnsibleApi.md#read) | **GET** {ansible_ansible_repository_href} | Inspect an ansible repository
*RepositoriesAnsibleApi* | [**rebuild_metadata**](docs/RepositoriesAnsibleApi.md#rebuild_metadata) | **POST** {ansible_ansible_repository_href}rebuild_metadata/ | 
*RepositoriesAnsibleApi* | [**remove_role**](docs/RepositoriesAnsibleApi.md#remove_role) | **POST** {ansible_ansible_repository_href}remove_role/ | 
*RepositoriesAnsibleApi* | [**sign**](docs/RepositoriesAnsibleApi.md#sign) | **POST** {ansible_ansible_repository_href}sign/ | 
*RepositoriesAnsibleApi* | [**sync**](docs/RepositoriesAnsibleApi.md#sync) | **POST** {ansible_ansible_repository_href}sync/ | 
*RepositoriesAnsibleApi* | [**unmark**](docs/RepositoriesAnsibleApi.md#unmark) | **POST** {ansible_ansible_repository_href}unmark/ | 
*RepositoriesAnsibleApi* | [**update**](docs/RepositoriesAnsibleApi.md#update) | **PUT** {ansible_ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleVersionsApi* | [**delete**](docs/RepositoriesAnsibleVersionsApi.md#delete) | **DELETE** {ansible_ansible_repository_version_href} | Delete a repository version
*RepositoriesAnsibleVersionsApi* | [**list**](docs/RepositoriesAnsibleVersionsApi.md#list) | **GET** {ansible_ansible_repository_href}versions/ | List repository versions
*RepositoriesAnsibleVersionsApi* | [**read**](docs/RepositoriesAnsibleVersionsApi.md#read) | **GET** {ansible_ansible_repository_version_href} | Inspect a repository version
*RepositoriesAnsibleVersionsApi* | [**rebuild_metadata**](docs/RepositoriesAnsibleVersionsApi.md#rebuild_metadata) | **POST** {ansible_ansible_repository_version_href}rebuild_metadata/ | 
*RepositoriesAnsibleVersionsApi* | [**repair**](docs/RepositoriesAnsibleVersionsApi.md#repair) | **POST** {ansible_ansible_repository_version_href}repair/ | 
*VersionsApi* | [**api_v1_roles_versions_list**](docs/VersionsApi.md#api_v1_roles_versions_list) | **GET** {ansible_role_href}versions/ | 
*VersionsApi* | [**api_v2_collection_versions_list**](docs/VersionsApi.md#api_v2_collection_versions_list) | **GET** {ansible_collection_version_href}versions/ | 


## Documentation For Models

 - [AnsibleAnsibleDistribution](docs/AnsibleAnsibleDistribution.md)
 - [AnsibleAnsibleDistributionResponse](docs/AnsibleAnsibleDistributionResponse.md)
 - [AnsibleAnsibleNamespaceMetadata](docs/AnsibleAnsibleNamespaceMetadata.md)
 - [AnsibleAnsibleNamespaceMetadataResponse](docs/AnsibleAnsibleNamespaceMetadataResponse.md)
 - [AnsibleAnsibleRepository](docs/AnsibleAnsibleRepository.md)
 - [AnsibleAnsibleRepositoryResponse](docs/AnsibleAnsibleRepositoryResponse.md)
 - [AnsibleCollection](docs/AnsibleCollection.md)
 - [AnsibleCollectionRemote](docs/AnsibleCollectionRemote.md)
 - [AnsibleCollectionRemoteResponse](docs/AnsibleCollectionRemoteResponse.md)
 - [AnsibleCollectionRemoteResponseHiddenFields](docs/AnsibleCollectionRemoteResponseHiddenFields.md)
 - [AnsibleCollectionResponse](docs/AnsibleCollectionResponse.md)
 - [AnsibleCollectionVersion](docs/AnsibleCollectionVersion.md)
 - [AnsibleCollectionVersionMark](docs/AnsibleCollectionVersionMark.md)
 - [AnsibleCollectionVersionMarkResponse](docs/AnsibleCollectionVersionMarkResponse.md)
 - [AnsibleCollectionVersionResponse](docs/AnsibleCollectionVersionResponse.md)
 - [AnsibleCollectionVersionSignature](docs/AnsibleCollectionVersionSignature.md)
 - [AnsibleCollectionVersionSignatureResponse](docs/AnsibleCollectionVersionSignatureResponse.md)
 - [AnsibleGitRemote](docs/AnsibleGitRemote.md)
 - [AnsibleGitRemoteResponse](docs/AnsibleGitRemoteResponse.md)
 - [AnsibleRepositoryMark](docs/AnsibleRepositoryMark.md)
 - [AnsibleRepositoryRebuild](docs/AnsibleRepositoryRebuild.md)
 - [AnsibleRepositorySignature](docs/AnsibleRepositorySignature.md)
 - [AnsibleRepositorySyncURL](docs/AnsibleRepositorySyncURL.md)
 - [AnsibleRole](docs/AnsibleRole.md)
 - [AnsibleRoleRemote](docs/AnsibleRoleRemote.md)
 - [AnsibleRoleRemoteResponse](docs/AnsibleRoleRemoteResponse.md)
 - [AnsibleRoleResponse](docs/AnsibleRoleResponse.md)
 - [AnsibleTagResponse](docs/AnsibleTagResponse.md)
 - [ArtifactRefResponse](docs/ArtifactRefResponse.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ClientConfigurationResponse](docs/ClientConfigurationResponse.md)
 - [CollectionImportDetailResponse](docs/CollectionImportDetailResponse.md)
 - [CollectionMetadataResponse](docs/CollectionMetadataResponse.md)
 - [CollectionNamespaceResponse](docs/CollectionNamespaceResponse.md)
 - [CollectionOneShot](docs/CollectionOneShot.md)
 - [CollectionRefResponse](docs/CollectionRefResponse.md)
 - [CollectionResponse](docs/CollectionResponse.md)
 - [CollectionSummaryResponse](docs/CollectionSummaryResponse.md)
 - [CollectionVersionCopyMove](docs/CollectionVersionCopyMove.md)
 - [CollectionVersionDocsResponse](docs/CollectionVersionDocsResponse.md)
 - [CollectionVersionListResponse](docs/CollectionVersionListResponse.md)
 - [CollectionVersionResponse](docs/CollectionVersionResponse.md)
 - [CollectionVersionSearchList](docs/CollectionVersionSearchList.md)
 - [CollectionVersionSearchListResponse](docs/CollectionVersionSearchListResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [Copy](docs/Copy.md)
 - [GalaxyCollection](docs/GalaxyCollection.md)
 - [GalaxyCollectionResponse](docs/GalaxyCollectionResponse.md)
 - [GalaxyCollectionVersionResponse](docs/GalaxyCollectionVersionResponse.md)
 - [GalaxyRoleResponse](docs/GalaxyRoleResponse.md)
 - [GalaxyRoleVersionResponse](docs/GalaxyRoleVersionResponse.md)
 - [MyPermissionsResponse](docs/MyPermissionsResponse.md)
 - [NamespaceLink](docs/NamespaceLink.md)
 - [NamespaceLinkResponse](docs/NamespaceLinkResponse.md)
 - [NestedRole](docs/NestedRole.md)
 - [NestedRoleResponse](docs/NestedRoleResponse.md)
 - [ObjectRolesResponse](docs/ObjectRolesResponse.md)
 - [PaginatedCollectionResponseList](docs/PaginatedCollectionResponseList.md)
 - [PaginatedCollectionResponseListLinks](docs/PaginatedCollectionResponseListLinks.md)
 - [PaginatedCollectionResponseListMeta](docs/PaginatedCollectionResponseListMeta.md)
 - [PaginatedCollectionVersionListResponseList](docs/PaginatedCollectionVersionListResponseList.md)
 - [PaginatedCollectionVersionSearchListResponseList](docs/PaginatedCollectionVersionSearchListResponseList.md)
 - [PaginatedGalaxyCollectionResponseList](docs/PaginatedGalaxyCollectionResponseList.md)
 - [PaginatedGalaxyCollectionVersionResponseList](docs/PaginatedGalaxyCollectionVersionResponseList.md)
 - [PaginatedGalaxyRoleResponseList](docs/PaginatedGalaxyRoleResponseList.md)
 - [PaginatedGalaxyRoleVersionResponseList](docs/PaginatedGalaxyRoleVersionResponseList.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedTagResponseList](docs/PaginatedTagResponseList.md)
 - [PaginatedansibleAnsibleDistributionResponseList](docs/PaginatedansibleAnsibleDistributionResponseList.md)
 - [PaginatedansibleAnsibleNamespaceMetadataResponseList](docs/PaginatedansibleAnsibleNamespaceMetadataResponseList.md)
 - [PaginatedansibleAnsibleRepositoryResponseList](docs/PaginatedansibleAnsibleRepositoryResponseList.md)
 - [PaginatedansibleCollectionRemoteResponseList](docs/PaginatedansibleCollectionRemoteResponseList.md)
 - [PaginatedansibleCollectionResponseList](docs/PaginatedansibleCollectionResponseList.md)
 - [PaginatedansibleCollectionVersionMarkResponseList](docs/PaginatedansibleCollectionVersionMarkResponseList.md)
 - [PaginatedansibleCollectionVersionResponseList](docs/PaginatedansibleCollectionVersionResponseList.md)
 - [PaginatedansibleCollectionVersionSignatureResponseList](docs/PaginatedansibleCollectionVersionSignatureResponseList.md)
 - [PaginatedansibleGitRemoteResponseList](docs/PaginatedansibleGitRemoteResponseList.md)
 - [PaginatedansibleRoleRemoteResponseList](docs/PaginatedansibleRoleRemoteResponseList.md)
 - [PaginatedansibleRoleResponseList](docs/PaginatedansibleRoleResponseList.md)
 - [PatchedansibleAnsibleDistribution](docs/PatchedansibleAnsibleDistribution.md)
 - [PatchedansibleAnsibleNamespaceMetadata](docs/PatchedansibleAnsibleNamespaceMetadata.md)
 - [PatchedansibleAnsibleRepository](docs/PatchedansibleAnsibleRepository.md)
 - [PatchedansibleCollectionRemote](docs/PatchedansibleCollectionRemote.md)
 - [PatchedansibleGitRemote](docs/PatchedansibleGitRemote.md)
 - [PatchedansibleRoleRemote](docs/PatchedansibleRoleRemote.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [ProgressReportResponse](docs/ProgressReportResponse.md)
 - [Repair](docs/Repair.md)
 - [RepoMetadataResponse](docs/RepoMetadataResponse.md)
 - [Repository](docs/Repository.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositoryResponse](docs/RepositoryResponse.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [TagResponse](docs/TagResponse.md)
 - [Task](docs/Task.md)
 - [TaskResponse](docs/TaskResponse.md)
 - [UnpaginatedCollectionVersionResponse](docs/UnpaginatedCollectionVersionResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## Author

pulp-list@redhat.com


