import * as lambda from '@aws-cdk/aws-lambda';
import * as sfn from '@aws-cdk/aws-stepfunctions';
/**
 * Properties for EvaluateExpression
 *
 * @experimental
 */
export interface EvaluateExpressionProps {
    /**
     * The expression to evaluate. The expression may contain state paths.
     *
     * @example '$.a + $.b'
     */
    readonly expression: string;
    /**
     * The runtime language to use to evaluate the expression.
     *
     * @default lambda.Runtime.NODEJS_10_X
     */
    readonly runtime?: lambda.Runtime;
}
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
export declare class EvaluateExpression implements sfn.IStepFunctionsTask {
    private readonly props;
    constructor(props: EvaluateExpressionProps);
    bind(task: sfn.Task): sfn.StepFunctionsTaskConfig;
}
