#!/usr/bin/env bash
# Test script for testing command entry points
#
#
# ARG_OPTIONAL_BOOLEAN([verbose],[v],[Displays details about the tests])
# ARG_OPTIONAL_BOOLEAN([clean],[c],[Removes created files])
# ARG_OPTIONAL_BOOLEAN([install-oval-graph],[i],[Install oval-graph from source])
# ARG_HELP([Show help])
# ARGBASH_GO()
# needed because of Argbash --> m4_ignore([
### START OF CODE GENERATED BY Argbash v2.9.0 one line above ###
# Argbash is a bash code generator used to get arguments parsing right.
# Argbash is FREE SOFTWARE, see https://argbash.io for more info
# Generated online by https://argbash.io/generate

die() {
    local _ret="${2:-1}"
    test "${_PRINT_HELP:-no}" = yes && print_help >&2
    echo "$1" >&2
    exit "${_ret}"
}

begins_with_short_option() {
    local first_option all_short_options='vcih'
    first_option="${1:0:1}"
    test "$all_short_options" = "${all_short_options/$first_option/}" && return 1 || return 0
}

# THE DEFAULTS INITIALIZATION - OPTIONALS
_arg_verbose="off"
_arg_clean="off"
_arg_install_oval_graph="off"

print_help() {
    printf '%s\n' "Show help"
    printf 'Usage: %s [-v|--(no-)verbose] [-c|--(no-)clean] [-i|--(no-)install-oval-graph] [-h|--help]\n' "$0"
    printf '\t%s\n' "-v, --verbose, --no-verbose: Displays details about the tests (off by default)"
    printf '\t%s\n' "-c, --clean, --no-clean: Removes created files (off by default)"
    printf '\t%s\n' "-i, --install-oval-graph, --no-install-oval-graph: Install oval-graph from source (off by default)"
    printf '\t%s\n' "-h, --help: Prints help"
}

parse_commandline() {
    while test $# -gt 0; do
        _key="$1"
        case "$_key" in
        -v | --no-verbose | --verbose)
            _arg_verbose="on"
            test "${1:0:5}" = "--no-" && _arg_verbose="off"
            ;;
        -v*)
            _arg_verbose="on"
            _next="${_key##-v}"
            if test -n "$_next" -a "$_next" != "$_key"; then
                { begins_with_short_option "$_next" && shift && set -- "-v" "-${_next}" "$@"; } || die "The short option '$_key' can't be decomposed to ${_key:0:2} and -${_key:2}, because ${_key:0:2} doesn't accept value and '-${_key:2:1}' doesn't correspond to a short option."
            fi
            ;;
        -c | --no-clean | --clean)
            _arg_clean="on"
            test "${1:0:5}" = "--no-" && _arg_clean="off"
            ;;
        -c*)
            _arg_clean="on"
            _next="${_key##-c}"
            if test -n "$_next" -a "$_next" != "$_key"; then
                { begins_with_short_option "$_next" && shift && set -- "-c" "-${_next}" "$@"; } || die "The short option '$_key' can't be decomposed to ${_key:0:2} and -${_key:2}, because ${_key:0:2} doesn't accept value and '-${_key:2:1}' doesn't correspond to a short option."
            fi
            ;;
        -i | --no-install-oval-graph | --install-oval-graph)
            _arg_install_oval_graph="on"
            test "${1:0:5}" = "--no-" && _arg_install_oval_graph="off"
            ;;
        -i*)
            _arg_install_oval_graph="on"
            _next="${_key##-i}"
            if test -n "$_next" -a "$_next" != "$_key"; then
                { begins_with_short_option "$_next" && shift && set -- "-i" "-${_next}" "$@"; } || die "The short option '$_key' can't be decomposed to ${_key:0:2} and -${_key:2}, because ${_key:0:2} doesn't accept value and '-${_key:2:1}' doesn't correspond to a short option."
            fi
            ;;
        -h | --help)
            print_help
            exit 0
            ;;
        -h*)
            print_help
            exit 0
            ;;
        *)
            _PRINT_HELP=yes die "FATAL ERROR: Got an unexpected argument '$1'" 1
            ;;
        esac
        shift
    done
}

parse_commandline "$@"

# OTHER STUFF GENERATED BY Argbash

### END OF CODE GENERATED BY Argbash (sortof) ### ])
# [ <-- needed because of Argbash

name="oval-graph"
test_file_src="./tests_oval_graph/global_test_data/ssg-fedora-ds-arf.xml"
tmp_dir_src="./tmp_data"
tmp_json_file_src="${tmp_dir_src}/data.json"

test_result=0
overall_test_result=0

test_if_is_instaled_oval_graph() {
    rpm -q $name >/dev/null 2>&1
    is_rpm_installed=$?
    pip list | grep -F $name
    is_pip_package_installed=$?
    if [ ! $is_rpm_installed ] || [ ! $is_pip_package_installed ]; then
        echo "$name NOT installed"
        exit 1
    fi
}

install_package_from_source() {
    install_pip="pip install --upgrade pip"
    install_oval_graph="pip install -e ."

    if [ "$_arg_verbose" = "on" ]; then
        echo "Start install"
        $install_pip
        $install_oval_graph
        echo "End install"
    else
        $install_pip &>/dev/null
        $install_oval_graph &>/dev/null
    fi
}

report() {
    if [ $test_result -eq 0 ]; then
        printf "Result: %-70s \x1b[32mpassed\x1b[0m\n" "$*"  # ]] <-- needed because of Argbash
    else
        printf "Result: %-70s \x1b[31mfailed\x1b[0m\n" "$*"  # ]] <-- needed because of Argbash
    fi
}

test_command() {
    test_name="$1"
    command="$2"
    msg=""
    echo "Start: $test_name"
    output=$($command 2>&1)
    exit_code=$?
    if [ $exit_code -eq 0 ]; then
        test_result=0
        msg="$test_name"
    else
        echo "$output"
        test_result=1
        overall_test_result=1
        msg="$test_name: $command"
    fi
    report "${msg}"
}

test_command_rise_error() {
    test_name="$1"
    command="$2"
    msg=""
    echo "Start: $test_name"
    output=$($command 2>&1)
    exit_code=$?
    if [ $exit_code -eq 2 ]; then
        test_result=0
        msg="$test_name"
    else
        echo "$output"
        test_result=1
        overall_test_result=1
        msg="$test_name: $command"
    fi
    report "${msg}"
}

test_of_command_output_contains_expected_str() {
    test_name="$1"
    command="$2"
    expected_str="$3"
    msg=""
    echo "Start: $test_name"
    output=$($command 2>&1)
    exit_code=$?
    if [[ $output =~ $expected_str ]]; then
        test_result=0
        msg="$test_name"
    else
        echo "$output"
        test_result=1
        overall_test_result=1
        msg="$test_name: $command"
    fi
    report "${msg}"
}

clean() {
    file=$1
    if [ "$_arg_verbose" = "on" ]; then
        echo "remove ${file}"
    fi
    rm -rf "${file}"
}

help_tests() {
    test_command arf-to-graph-help "arf-to-graph -h"
    test_command arf-to-json-help "arf-to-json -h"
    test_command json-to-graph-help "json-to-graph -h"
}

bad_args_tests() {
    test_command_rise_error arf-to-graph-bad_arg "arf-to-graph -hello"
    test_command_rise_error arf-to-json-bad_arg "arf-to-json -hello"
    test_command_rise_error json-to-graph-bad_arg "json-to-graph -hello"
}

basic_test() {
    test_command run-arf-to-graph "arf-to-graph -o ${tmp_dir_src} ${test_file_src} fips"
    test_command run-arf-to-json "arf-to-json -o ${tmp_json_file_src} ${test_file_src} fips"
    test_command run-json-to-graph "json-to-graph -o ${tmp_dir_src} ${tmp_json_file_src} fips"
}

regex_and_all_test() {
    test_command run-arf-to-graph_regex "arf-to-graph -o ${tmp_dir_src} ${test_file_src} -a _package_\w+_removed"
    test_command run-arf-to-json_regex "arf-to-json -o ${tmp_json_file_src} ${test_file_src} -a _package_\w+_removed"
    test_command run-json-to-graph_regex "json-to-graph -o ${tmp_dir_src} ${tmp_json_file_src} -a _package_\w+_removed"
}

regex_and_all_in_one_test() {
    test_command run-arf-to-graph_regex "arf-to-graph -o ${tmp_dir_src} ${test_file_src} -i _package_\w+_removed"
    test_command run-json-to-graph_regex "json-to-graph -o ${tmp_dir_src} ${tmp_json_file_src} -i _package_\w+_removed"
}

hide_all_passing_tests_test() {
    test_command run-arf-to-graph "arf-to-graph -o ${tmp_dir_src} ${test_file_src} --hide-passing-tests fips"
    test_command run-json-to-graph "json-to-graph -o ${tmp_dir_src} ${tmp_json_file_src} --hide-passing-tests -i fips"
}

test_of_reference_to_right_binary_in_help() {
    test_of_command_output_contains_expected_str expect_right_reference_in_help "arf-to-graph -h" "arf-to-graph"
    test_of_command_output_contains_expected_str expect_right_reference_in_help "arf-to-json -h" "arf-to-json"
    test_of_command_output_contains_expected_str expect_right_reference_in_help "json-to-graph -h" "json-to-graph"
}

# Backup descriptors stdout -> 3, stderr -> 4
exec 3>&1 4>&2

# Redirect stdout and stderr to file
exec &>test_commands.log

if [ "$_arg_install_oval_graph" = "on" ]; then
    install_package_from_source
fi

test_if_is_instaled_oval_graph
clean "${tmp_json_file_src}"
help_tests
bad_args_tests
basic_test
regex_and_all_test
regex_and_all_in_one_test
hide_all_passing_tests_test
test_of_reference_to_right_binary_in_help

if [ "$_arg_clean" = "on" ]; then
    clean "${tmp_dir_src}"
fi

if [[ ("$_arg_verbose" = "on") || ($overall_test_result -eq 1) ]]; then
    # Restore descriptors
    exec 1>&3 2>&4
    cat test_commands.log
fi

exit "$overall_test_result"
# ] <-- needed because of Argbash
