from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class CompositionHookList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, enabled: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, enabled: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, enabled: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., friendly_name: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, friendly_name: Any, enabled: Any = ..., video_layout: Any = ..., audio_sources: Any = ..., audio_sources_excluded: Any = ..., resolution: Any = ..., format: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., trim: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class CompositionHookPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class CompositionHookContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any, enabled: Any = ..., video_layout: Any = ..., audio_sources: Any = ..., audio_sources_excluded: Any = ..., trim: Any = ..., format: Any = ..., resolution: Any = ..., status_callback: Any = ..., status_callback_method: Any = ...): ...

class CompositionHookInstance(InstanceResource):
    class Format:
        MP4: str = ...
        WEBM: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def enabled(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def sid(self): ...
    @property
    def audio_sources(self): ...
    @property
    def audio_sources_excluded(self): ...
    @property
    def video_layout(self): ...
    @property
    def resolution(self): ...
    @property
    def trim(self): ...
    @property
    def format(self): ...
    @property
    def status_callback(self): ...
    @property
    def status_callback_method(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any, enabled: Any = ..., video_layout: Any = ..., audio_sources: Any = ..., audio_sources_excluded: Any = ..., trim: Any = ..., format: Any = ..., resolution: Any = ..., status_callback: Any = ..., status_callback_method: Any = ...): ...
