from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class CompositionList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, status: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., room_sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, status: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., room_sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, status: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., room_sid: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, room_sid: Any, video_layout: Any = ..., audio_sources: Any = ..., audio_sources_excluded: Any = ..., resolution: Any = ..., format: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., trim: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class CompositionPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class CompositionContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...

class CompositionInstance(InstanceResource):
    class Status:
        ENQUEUED: str = ...
        PROCESSING: str = ...
        COMPLETED: str = ...
        DELETED: str = ...
        FAILED: str = ...
    class Format:
        MP4: str = ...
        WEBM: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def status(self): ...
    @property
    def date_created(self): ...
    @property
    def date_completed(self): ...
    @property
    def date_deleted(self): ...
    @property
    def sid(self): ...
    @property
    def room_sid(self): ...
    @property
    def audio_sources(self): ...
    @property
    def audio_sources_excluded(self): ...
    @property
    def video_layout(self): ...
    @property
    def resolution(self): ...
    @property
    def trim(self): ...
    @property
    def format(self): ...
    @property
    def bitrate(self): ...
    @property
    def size(self): ...
    @property
    def duration(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
