from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class ChallengeList(ListResource):
    def __init__(self, version: Any, service_sid: Any, identity: Any) -> None: ...
    def create(self, factor_sid: Any, expiration_date: Any = ..., details_message: Any = ..., details_fields: Any = ..., hidden_details: Any = ...): ...
    def stream(self, factor_sid: Any = ..., status: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, factor_sid: Any = ..., status: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, factor_sid: Any = ..., status: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ChallengePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ChallengeContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, identity: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, auth_payload: Any = ...): ...

class ChallengeInstance(InstanceResource):
    class ChallengeStatuses:
        PENDING: str = ...
        EXPIRED: str = ...
        APPROVED: str = ...
        DENIED: str = ...
    class ChallengeReasons:
        NONE: str = ...
        NOT_NEEDED: str = ...
        NOT_REQUESTED: str = ...
    class FactorTypes:
        PUSH: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, identity: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def entity_sid(self): ...
    @property
    def identity(self): ...
    @property
    def factor_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def date_responded(self): ...
    @property
    def expiration_date(self): ...
    @property
    def status(self): ...
    @property
    def responded_reason(self): ...
    @property
    def details(self): ...
    @property
    def hidden_details(self): ...
    @property
    def factor_type(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
    def update(self, auth_payload: Any = ...): ...
