from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class PhoneNumberList(ListResource):
    def __init__(self, version: Any, trunk_sid: Any) -> None: ...
    def create(self, phone_number_sid: Any): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class PhoneNumberPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class PhoneNumberContext(InstanceContext):
    def __init__(self, version: Any, trunk_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...

class PhoneNumberInstance(InstanceResource):
    class AddressRequirement:
        NONE: str = ...
        ANY: str = ...
        LOCAL: str = ...
        FOREIGN: str = ...
    def __init__(self, version: Any, payload: Any, trunk_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def address_requirements(self): ...
    @property
    def api_version(self): ...
    @property
    def beta(self): ...
    @property
    def capabilities(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def friendly_name(self): ...
    @property
    def links(self): ...
    @property
    def phone_number(self): ...
    @property
    def sid(self): ...
    @property
    def sms_application_sid(self): ...
    @property
    def sms_fallback_method(self): ...
    @property
    def sms_fallback_url(self): ...
    @property
    def sms_method(self): ...
    @property
    def sms_url(self): ...
    @property
    def status_callback(self): ...
    @property
    def status_callback_method(self): ...
    @property
    def trunk_sid(self): ...
    @property
    def url(self): ...
    @property
    def voice_application_sid(self): ...
    @property
    def voice_caller_id_lookup(self): ...
    @property
    def voice_fallback_method(self): ...
    @property
    def voice_fallback_url(self): ...
    @property
    def voice_method(self): ...
    @property
    def voice_url(self): ...
    def fetch(self): ...
    def delete(self): ...
