from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.trunking.v1.trunk.credential_list import CredentialListList as CredentialListList
from twilio.rest.trunking.v1.trunk.ip_access_control_list import IpAccessControlListList as IpAccessControlListList
from twilio.rest.trunking.v1.trunk.origination_url import OriginationUrlList as OriginationUrlList
from twilio.rest.trunking.v1.trunk.phone_number import PhoneNumberList as PhoneNumberList
from twilio.rest.trunking.v1.trunk.recording import RecordingList as RecordingList
from typing import Any, Optional

class TrunkList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any = ..., domain_name: Any = ..., disaster_recovery_url: Any = ..., disaster_recovery_method: Any = ..., transfer_mode: Any = ..., secure: Any = ..., cnam_lookup_enabled: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class TrunkPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class TrunkContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any = ..., domain_name: Any = ..., disaster_recovery_url: Any = ..., disaster_recovery_method: Any = ..., transfer_mode: Any = ..., secure: Any = ..., cnam_lookup_enabled: Any = ...): ...
    @property
    def origination_urls(self): ...
    @property
    def credentials_lists(self): ...
    @property
    def ip_access_control_lists(self): ...
    @property
    def phone_numbers(self): ...
    @property
    def recordings(self): ...

class TrunkInstance(InstanceResource):
    class TransferSetting:
        DISABLE_ALL: str = ...
        ENABLE_ALL: str = ...
        SIP_ONLY: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def domain_name(self): ...
    @property
    def disaster_recovery_method(self): ...
    @property
    def disaster_recovery_url(self): ...
    @property
    def friendly_name(self): ...
    @property
    def secure(self): ...
    @property
    def recording(self): ...
    @property
    def transfer_mode(self): ...
    @property
    def cnam_lookup_enabled(self): ...
    @property
    def auth_type(self): ...
    @property
    def auth_type_set(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def sid(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any = ..., domain_name: Any = ..., disaster_recovery_url: Any = ..., disaster_recovery_method: Any = ..., transfer_mode: Any = ..., secure: Any = ..., cnam_lookup_enabled: Any = ...): ...
    @property
    def origination_urls(self): ...
    @property
    def credentials_lists(self): ...
    @property
    def ip_access_control_lists(self): ...
    @property
    def phone_numbers(self): ...
    @property
    def recordings(self): ...
