from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.taskrouter.v1.workspace.workflow.workflow_cumulative_statistics import WorkflowCumulativeStatisticsList as WorkflowCumulativeStatisticsList
from twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics import WorkflowRealTimeStatisticsList as WorkflowRealTimeStatisticsList
from twilio.rest.taskrouter.v1.workspace.workflow.workflow_statistics import WorkflowStatisticsList as WorkflowStatisticsList
from typing import Any, Optional

class WorkflowList(ListResource):
    def __init__(self, version: Any, workspace_sid: Any) -> None: ...
    def stream(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, friendly_name: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, friendly_name: Any, configuration: Any, assignment_callback_url: Any = ..., fallback_assignment_callback_url: Any = ..., task_reservation_timeout: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class WorkflowPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class WorkflowContext(InstanceContext):
    def __init__(self, version: Any, workspace_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., assignment_callback_url: Any = ..., fallback_assignment_callback_url: Any = ..., configuration: Any = ..., task_reservation_timeout: Any = ..., re_evaluate_tasks: Any = ...): ...
    def delete(self): ...
    @property
    def statistics(self): ...
    @property
    def real_time_statistics(self): ...
    @property
    def cumulative_statistics(self): ...

class WorkflowInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, workspace_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def assignment_callback_url(self): ...
    @property
    def configuration(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def document_content_type(self): ...
    @property
    def fallback_assignment_callback_url(self): ...
    @property
    def friendly_name(self): ...
    @property
    def sid(self): ...
    @property
    def task_reservation_timeout(self): ...
    @property
    def workspace_sid(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., assignment_callback_url: Any = ..., fallback_assignment_callback_url: Any = ..., configuration: Any = ..., task_reservation_timeout: Any = ..., re_evaluate_tasks: Any = ...): ...
    def delete(self): ...
    @property
    def statistics(self): ...
    @property
    def real_time_statistics(self): ...
    @property
    def cumulative_statistics(self): ...
