from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.taskrouter.v1.workspace.worker.reservation import ReservationList as ReservationList
from twilio.rest.taskrouter.v1.workspace.worker.worker_channel import WorkerChannelList as WorkerChannelList
from twilio.rest.taskrouter.v1.workspace.worker.worker_statistics import WorkerStatisticsList as WorkerStatisticsList
from twilio.rest.taskrouter.v1.workspace.worker.workers_cumulative_statistics import WorkersCumulativeStatisticsList as WorkersCumulativeStatisticsList
from twilio.rest.taskrouter.v1.workspace.worker.workers_real_time_statistics import WorkersRealTimeStatisticsList as WorkersRealTimeStatisticsList
from twilio.rest.taskrouter.v1.workspace.worker.workers_statistics import WorkersStatisticsList as WorkersStatisticsList
from typing import Any, Optional

class WorkerList(ListResource):
    def __init__(self, version: Any, workspace_sid: Any) -> None: ...
    def stream(self, activity_name: Any = ..., activity_sid: Any = ..., available: Any = ..., friendly_name: Any = ..., target_workers_expression: Any = ..., task_queue_name: Any = ..., task_queue_sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, activity_name: Any = ..., activity_sid: Any = ..., available: Any = ..., friendly_name: Any = ..., target_workers_expression: Any = ..., task_queue_name: Any = ..., task_queue_sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, activity_name: Any = ..., activity_sid: Any = ..., available: Any = ..., friendly_name: Any = ..., target_workers_expression: Any = ..., task_queue_name: Any = ..., task_queue_sid: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, friendly_name: Any, activity_sid: Any = ..., attributes: Any = ...): ...
    @property
    def statistics(self): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class WorkerPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class WorkerContext(InstanceContext):
    def __init__(self, version: Any, workspace_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, activity_sid: Any = ..., attributes: Any = ..., friendly_name: Any = ..., reject_pending_reservations: Any = ...): ...
    def delete(self): ...
    @property
    def real_time_statistics(self): ...
    @property
    def cumulative_statistics(self): ...
    @property
    def statistics(self): ...
    @property
    def reservations(self): ...
    @property
    def worker_channels(self): ...

class WorkerInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, workspace_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def activity_name(self): ...
    @property
    def activity_sid(self): ...
    @property
    def attributes(self): ...
    @property
    def available(self): ...
    @property
    def date_created(self): ...
    @property
    def date_status_changed(self): ...
    @property
    def date_updated(self): ...
    @property
    def friendly_name(self): ...
    @property
    def sid(self): ...
    @property
    def workspace_sid(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, activity_sid: Any = ..., attributes: Any = ..., friendly_name: Any = ..., reject_pending_reservations: Any = ...): ...
    def delete(self): ...
    @property
    def real_time_statistics(self): ...
    @property
    def cumulative_statistics(self): ...
    @property
    def statistics(self): ...
    @property
    def reservations(self): ...
    @property
    def worker_channels(self): ...
