from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.taskrouter.v1.workspace.task.reservation import ReservationList as ReservationList
from typing import Any, Optional

class TaskList(ListResource):
    def __init__(self, version: Any, workspace_sid: Any) -> None: ...
    def stream(self, priority: Any = ..., assignment_status: Any = ..., workflow_sid: Any = ..., workflow_name: Any = ..., task_queue_sid: Any = ..., task_queue_name: Any = ..., evaluate_task_attributes: Any = ..., ordering: Any = ..., has_addons: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, priority: Any = ..., assignment_status: Any = ..., workflow_sid: Any = ..., workflow_name: Any = ..., task_queue_sid: Any = ..., task_queue_name: Any = ..., evaluate_task_attributes: Any = ..., ordering: Any = ..., has_addons: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, priority: Any = ..., assignment_status: Any = ..., workflow_sid: Any = ..., workflow_name: Any = ..., task_queue_sid: Any = ..., task_queue_name: Any = ..., evaluate_task_attributes: Any = ..., ordering: Any = ..., has_addons: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, timeout: Any = ..., priority: Any = ..., task_channel: Any = ..., workflow_sid: Any = ..., attributes: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class TaskPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class TaskContext(InstanceContext):
    def __init__(self, version: Any, workspace_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, attributes: Any = ..., assignment_status: Any = ..., reason: Any = ..., priority: Any = ..., task_channel: Any = ...): ...
    def delete(self): ...
    @property
    def reservations(self): ...

class TaskInstance(InstanceResource):
    class Status:
        PENDING: str = ...
        RESERVED: str = ...
        ASSIGNED: str = ...
        CANCELED: str = ...
        COMPLETED: str = ...
        WRAPPING: str = ...
    def __init__(self, version: Any, payload: Any, workspace_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def age(self): ...
    @property
    def assignment_status(self): ...
    @property
    def attributes(self): ...
    @property
    def addons(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def task_queue_entered_date(self): ...
    @property
    def priority(self): ...
    @property
    def reason(self): ...
    @property
    def sid(self): ...
    @property
    def task_queue_sid(self): ...
    @property
    def task_queue_friendly_name(self): ...
    @property
    def task_channel_sid(self): ...
    @property
    def task_channel_unique_name(self): ...
    @property
    def timeout(self): ...
    @property
    def workflow_sid(self): ...
    @property
    def workflow_friendly_name(self): ...
    @property
    def workspace_sid(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, attributes: Any = ..., assignment_status: Any = ..., reason: Any = ..., priority: Any = ..., task_channel: Any = ...): ...
    def delete(self): ...
    @property
    def reservations(self): ...
