from twilio.base import values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class NetworkAccessProfileNetworkList(ListResource):
    def __init__(self, version: Any, network_access_profile_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, network: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class NetworkAccessProfileNetworkPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class NetworkAccessProfileNetworkContext(InstanceContext):
    def __init__(self, version: Any, network_access_profile_sid: Any, sid: Any) -> None: ...
    def delete(self): ...
    def fetch(self): ...

class NetworkAccessProfileNetworkInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, network_access_profile_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def network_access_profile_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def iso_country(self): ...
    @property
    def identifiers(self): ...
    @property
    def url(self): ...
    def delete(self): ...
    def fetch(self): ...
