from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.studio.v2.flow.execution import ExecutionList as ExecutionList
from twilio.rest.studio.v2.flow.flow_revision import FlowRevisionList as FlowRevisionList
from twilio.rest.studio.v2.flow.test_user import FlowTestUserList as FlowTestUserList
from typing import Any, Optional

class FlowList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any, status: Any, definition: Any, commit_message: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class FlowPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class FlowContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def update(self, status: Any, friendly_name: Any = ..., definition: Any = ..., commit_message: Any = ...): ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def revisions(self): ...
    @property
    def test_users(self): ...
    @property
    def executions(self): ...

class FlowInstance(InstanceResource):
    class Status:
        DRAFT: str = ...
        PUBLISHED: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def definition(self): ...
    @property
    def status(self): ...
    @property
    def revision(self): ...
    @property
    def commit_message(self): ...
    @property
    def valid(self): ...
    @property
    def errors(self): ...
    @property
    def warnings(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def webhook_url(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def update(self, status: Any, friendly_name: Any = ..., definition: Any = ..., commit_message: Any = ...): ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def revisions(self): ...
    @property
    def test_users(self): ...
    @property
    def executions(self): ...
