from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.serverless.v1.service.function.function_version.function_version_content import FunctionVersionContentList as FunctionVersionContentList
from typing import Any, Optional

class FunctionVersionList(ListResource):
    def __init__(self, version: Any, service_sid: Any, function_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class FunctionVersionPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class FunctionVersionContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, function_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    @property
    def function_version_content(self): ...

class FunctionVersionInstance(InstanceResource):
    class Visibility:
        PUBLIC: str = ...
        PRIVATE: str = ...
        PROTECTED: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, function_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def function_sid(self): ...
    @property
    def path(self): ...
    @property
    def visibility(self): ...
    @property
    def date_created(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    @property
    def function_version_content(self): ...
