from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class AssetVersionList(ListResource):
    def __init__(self, version: Any, service_sid: Any, asset_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class AssetVersionPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class AssetVersionContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, asset_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...

class AssetVersionInstance(InstanceResource):
    class Visibility:
        PUBLIC: str = ...
        PRIVATE: str = ...
        PROTECTED: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, asset_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def asset_sid(self): ...
    @property
    def path(self): ...
    @property
    def visibility(self): ...
    @property
    def date_created(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
