from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.preview.sync.service.document.document_permission import DocumentPermissionList as DocumentPermissionList
from typing import Any, Optional

class DocumentList(ListResource):
    def __init__(self, version: Any, service_sid: Any) -> None: ...
    def create(self, unique_name: Any = ..., data: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class DocumentPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class DocumentContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self, if_match: Any = ...): ...
    def update(self, data: Any, if_match: Any = ...): ...
    @property
    def document_permissions(self): ...

class DocumentInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, service_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def unique_name(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    @property
    def revision(self): ...
    @property
    def data(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def created_by(self): ...
    def fetch(self): ...
    def delete(self, if_match: Any = ...): ...
    def update(self, data: Any, if_match: Any = ...): ...
    @property
    def document_permissions(self): ...
