from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.preview.deployed_devices.fleet.certificate import CertificateList as CertificateList
from twilio.rest.preview.deployed_devices.fleet.deployment import DeploymentList as DeploymentList
from twilio.rest.preview.deployed_devices.fleet.device import DeviceList as DeviceList
from twilio.rest.preview.deployed_devices.fleet.key import KeyList as KeyList
from typing import Any, Optional

class FleetList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class FleetPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class FleetContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any = ..., default_deployment_sid: Any = ...): ...
    @property
    def devices(self): ...
    @property
    def deployments(self): ...
    @property
    def certificates(self): ...
    @property
    def keys(self): ...

class FleetInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def url(self): ...
    @property
    def unique_name(self): ...
    @property
    def friendly_name(self): ...
    @property
    def account_sid(self): ...
    @property
    def default_deployment_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any = ..., default_deployment_sid: Any = ...): ...
    @property
    def devices(self): ...
    @property
    def deployments(self): ...
    @property
    def certificates(self): ...
    @property
    def keys(self): ...
