from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.numbers.v2.regulatory_compliance.bundle.evaluation import EvaluationList as EvaluationList
from twilio.rest.numbers.v2.regulatory_compliance.bundle.item_assignment import ItemAssignmentList as ItemAssignmentList
from typing import Any, Optional

class BundleList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any, email: Any, status_callback: Any = ..., regulation_sid: Any = ..., iso_country: Any = ..., end_user_type: Any = ..., number_type: Any = ...): ...
    def stream(self, status: Any = ..., friendly_name: Any = ..., regulation_sid: Any = ..., iso_country: Any = ..., number_type: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, status: Any = ..., friendly_name: Any = ..., regulation_sid: Any = ..., iso_country: Any = ..., number_type: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, status: Any = ..., friendly_name: Any = ..., regulation_sid: Any = ..., iso_country: Any = ..., number_type: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class BundlePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class BundleContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, status: Any = ..., status_callback: Any = ..., friendly_name: Any = ..., email: Any = ...): ...
    def delete(self): ...
    @property
    def evaluations(self): ...
    @property
    def item_assignments(self): ...

class BundleInstance(InstanceResource):
    class Status:
        DRAFT: str = ...
        PENDING_REVIEW: str = ...
        IN_REVIEW: str = ...
        TWILIO_REJECTED: str = ...
        TWILIO_APPROVED: str = ...
        PROVISIONALLY_APPROVED: str = ...
    class EndUserType:
        INDIVIDUAL: str = ...
        BUSINESS: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def regulation_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def status(self): ...
    @property
    def valid_until(self): ...
    @property
    def email(self): ...
    @property
    def status_callback(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, status: Any = ..., status_callback: Any = ..., friendly_name: Any = ..., email: Any = ...): ...
    def delete(self): ...
    @property
    def evaluations(self): ...
    @property
    def item_assignments(self): ...
