from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class UserChannelList(ListResource):
    def __init__(self, version: Any, service_sid: Any, user_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, channel_sid: Any): ...
    def __call__(self, channel_sid: Any): ...

class UserChannelPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class UserChannelContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, user_sid: Any, channel_sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, notification_level: Any = ..., last_consumed_message_index: Any = ..., last_consumption_timestamp: Any = ...): ...

class UserChannelInstance(InstanceResource):
    class ChannelStatus:
        JOINED: str = ...
        INVITED: str = ...
        NOT_PARTICIPATING: str = ...
    class NotificationLevel:
        DEFAULT: str = ...
        MUTED: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, user_sid: Any, channel_sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def channel_sid(self): ...
    @property
    def user_sid(self): ...
    @property
    def member_sid(self): ...
    @property
    def status(self): ...
    @property
    def last_consumed_message_index(self): ...
    @property
    def unread_messages_count(self): ...
    @property
    def links(self): ...
    @property
    def url(self): ...
    @property
    def notification_level(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, notification_level: Any = ..., last_consumed_message_index: Any = ..., last_consumption_timestamp: Any = ...): ...
