from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class FlexFlowList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, friendly_name: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, friendly_name: Any, chat_service_sid: Any, channel_type: Any, contact_identity: Any = ..., enabled: Any = ..., integration_type: Any = ..., integration_flow_sid: Any = ..., integration_url: Any = ..., integration_workspace_sid: Any = ..., integration_workflow_sid: Any = ..., integration_channel: Any = ..., integration_timeout: Any = ..., integration_priority: Any = ..., integration_creation_on_message: Any = ..., long_lived: Any = ..., janitor_enabled: Any = ..., integration_retry_count: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class FlexFlowPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class FlexFlowContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., chat_service_sid: Any = ..., channel_type: Any = ..., contact_identity: Any = ..., enabled: Any = ..., integration_type: Any = ..., integration_flow_sid: Any = ..., integration_url: Any = ..., integration_workspace_sid: Any = ..., integration_workflow_sid: Any = ..., integration_channel: Any = ..., integration_timeout: Any = ..., integration_priority: Any = ..., integration_creation_on_message: Any = ..., long_lived: Any = ..., janitor_enabled: Any = ..., integration_retry_count: Any = ...): ...
    def delete(self): ...

class FlexFlowInstance(InstanceResource):
    class ChannelType:
        WEB: str = ...
        SMS: str = ...
        FACEBOOK: str = ...
        WHATSAPP: str = ...
        LINE: str = ...
        CUSTOM: str = ...
    class IntegrationType:
        STUDIO: str = ...
        EXTERNAL: str = ...
        TASK: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def chat_service_sid(self): ...
    @property
    def channel_type(self): ...
    @property
    def contact_identity(self): ...
    @property
    def enabled(self): ...
    @property
    def integration_type(self): ...
    @property
    def integration(self): ...
    @property
    def long_lived(self): ...
    @property
    def janitor_enabled(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., chat_service_sid: Any = ..., channel_type: Any = ..., contact_identity: Any = ..., enabled: Any = ..., integration_type: Any = ..., integration_flow_sid: Any = ..., integration_url: Any = ..., integration_workspace_sid: Any = ..., integration_workflow_sid: Any = ..., integration_channel: Any = ..., integration_timeout: Any = ..., integration_priority: Any = ..., integration_creation_on_message: Any = ..., long_lived: Any = ..., janitor_enabled: Any = ..., integration_retry_count: Any = ...): ...
    def delete(self): ...
