from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class UserBindingList(ListResource):
    def __init__(self, version: Any, service_sid: Any, user_sid: Any) -> None: ...
    def stream(self, binding_type: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, binding_type: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, binding_type: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class UserBindingPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class UserBindingContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, user_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...

class UserBindingInstance(InstanceResource):
    class BindingType:
        GCM: str = ...
        APN: str = ...
        FCM: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, user_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def endpoint(self): ...
    @property
    def identity(self): ...
    @property
    def user_sid(self): ...
    @property
    def credential_sid(self): ...
    @property
    def binding_type(self): ...
    @property
    def message_types(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
    def delete(self): ...
