from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class MessageList(ListResource):
    def __init__(self, version: Any, service_sid: Any, channel_sid: Any) -> None: ...
    def create(self, from_: Any = ..., attributes: Any = ..., date_created: Any = ..., date_updated: Any = ..., last_updated_by: Any = ..., body: Any = ..., media_sid: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def stream(self, order: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, order: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, order: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class MessagePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class MessageContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, channel_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def update(self, body: Any = ..., attributes: Any = ..., date_created: Any = ..., date_updated: Any = ..., last_updated_by: Any = ..., from_: Any = ..., x_twilio_webhook_enabled: Any = ...): ...

class MessageInstance(InstanceResource):
    class OrderType:
        ASC: str = ...
        DESC: str = ...
    class WebhookEnabledType:
        TRUE: str = ...
        FALSE: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, channel_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def attributes(self): ...
    @property
    def service_sid(self): ...
    @property
    def to(self): ...
    @property
    def channel_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def last_updated_by(self): ...
    @property
    def was_edited(self): ...
    @property
    def from_(self): ...
    @property
    def body(self): ...
    @property
    def index(self): ...
    @property
    def type(self): ...
    @property
    def media(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def update(self, body: Any = ..., attributes: Any = ..., date_created: Any = ..., date_updated: Any = ..., last_updated_by: Any = ..., from_: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
