from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.api.v2010.account.sip.domain.auth_types import AuthTypesList as AuthTypesList
from twilio.rest.api.v2010.account.sip.domain.credential_list_mapping import CredentialListMappingList as CredentialListMappingList
from twilio.rest.api.v2010.account.sip.domain.ip_access_control_list_mapping import IpAccessControlListMappingList as IpAccessControlListMappingList
from typing import Any, Optional

class DomainList(ListResource):
    def __init__(self, version: Any, account_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, domain_name: Any, friendly_name: Any = ..., voice_url: Any = ..., voice_method: Any = ..., voice_fallback_url: Any = ..., voice_fallback_method: Any = ..., voice_status_callback_url: Any = ..., voice_status_callback_method: Any = ..., sip_registration: Any = ..., emergency_calling_enabled: Any = ..., secure: Any = ..., byoc_trunk_sid: Any = ..., emergency_caller_sid: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class DomainPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class DomainContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., voice_fallback_method: Any = ..., voice_fallback_url: Any = ..., voice_method: Any = ..., voice_status_callback_method: Any = ..., voice_status_callback_url: Any = ..., voice_url: Any = ..., sip_registration: Any = ..., domain_name: Any = ..., emergency_calling_enabled: Any = ..., secure: Any = ..., byoc_trunk_sid: Any = ..., emergency_caller_sid: Any = ...): ...
    def delete(self): ...
    @property
    def ip_access_control_list_mappings(self): ...
    @property
    def credential_list_mappings(self): ...
    @property
    def auth(self): ...

class DomainInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, account_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def api_version(self): ...
    @property
    def auth_type(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def domain_name(self): ...
    @property
    def friendly_name(self): ...
    @property
    def sid(self): ...
    @property
    def uri(self): ...
    @property
    def voice_fallback_method(self): ...
    @property
    def voice_fallback_url(self): ...
    @property
    def voice_method(self): ...
    @property
    def voice_status_callback_method(self): ...
    @property
    def voice_status_callback_url(self): ...
    @property
    def voice_url(self): ...
    @property
    def subresource_uris(self): ...
    @property
    def sip_registration(self): ...
    @property
    def emergency_calling_enabled(self): ...
    @property
    def secure(self): ...
    @property
    def byoc_trunk_sid(self): ...
    @property
    def emergency_caller_sid(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., voice_fallback_method: Any = ..., voice_fallback_url: Any = ..., voice_method: Any = ..., voice_status_callback_method: Any = ..., voice_status_callback_url: Any = ..., voice_url: Any = ..., sip_registration: Any = ..., domain_name: Any = ..., emergency_calling_enabled: Any = ..., secure: Any = ..., byoc_trunk_sid: Any = ..., emergency_caller_sid: Any = ...): ...
    def delete(self): ...
    @property
    def ip_access_control_list_mappings(self): ...
    @property
    def credential_list_mappings(self): ...
    @property
    def auth(self): ...
