from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class TranscriptionList(ListResource):
    def __init__(self, version: Any, account_sid: Any, recording_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class TranscriptionPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class TranscriptionContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, recording_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...

class TranscriptionInstance(InstanceResource):
    class Status:
        IN_PROGRESS: str = ...
        COMPLETED: str = ...
        FAILED: str = ...
    def __init__(self, version: Any, payload: Any, account_sid: Any, recording_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def api_version(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def duration(self): ...
    @property
    def price(self): ...
    @property
    def price_unit(self): ...
    @property
    def recording_sid(self): ...
    @property
    def sid(self): ...
    @property
    def status(self): ...
    @property
    def transcription_text(self): ...
    @property
    def type(self): ...
    @property
    def uri(self): ...
    def fetch(self): ...
    def delete(self): ...
