from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.api.v2010.account.recording.add_on_result import AddOnResultList as AddOnResultList
from twilio.rest.api.v2010.account.recording.transcription import TranscriptionList as TranscriptionList
from typing import Any, Optional

class RecordingList(ListResource):
    def __init__(self, version: Any, account_sid: Any) -> None: ...
    def stream(self, date_created_before: Any = ..., date_created: Any = ..., date_created_after: Any = ..., call_sid: Any = ..., conference_sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, date_created_before: Any = ..., date_created: Any = ..., date_created_after: Any = ..., call_sid: Any = ..., conference_sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, date_created_before: Any = ..., date_created: Any = ..., date_created_after: Any = ..., call_sid: Any = ..., conference_sid: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class RecordingPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class RecordingContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def transcriptions(self): ...
    @property
    def add_on_results(self): ...

class RecordingInstance(InstanceResource):
    class Status:
        IN_PROGRESS: str = ...
        PAUSED: str = ...
        STOPPED: str = ...
        PROCESSING: str = ...
        COMPLETED: str = ...
        ABSENT: str = ...
    class Source:
        DIALVERB: str = ...
        CONFERENCE: str = ...
        OUTBOUNDAPI: str = ...
        TRUNKING: str = ...
        RECORDVERB: str = ...
        STARTCALLRECORDINGAPI: str = ...
        STARTCONFERENCERECORDINGAPI: str = ...
    def __init__(self, version: Any, payload: Any, account_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def api_version(self): ...
    @property
    def call_sid(self): ...
    @property
    def conference_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def start_time(self): ...
    @property
    def duration(self): ...
    @property
    def sid(self): ...
    @property
    def price(self): ...
    @property
    def price_unit(self): ...
    @property
    def status(self): ...
    @property
    def channels(self): ...
    @property
    def source(self): ...
    @property
    def error_code(self): ...
    @property
    def uri(self): ...
    @property
    def encryption_details(self): ...
    @property
    def subresource_uris(self): ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def transcriptions(self): ...
    @property
    def add_on_results(self): ...
