from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class PaymentList(ListResource):
    def __init__(self, version: Any, account_sid: Any, call_sid: Any) -> None: ...
    def create(self, idempotency_key: Any, status_callback: Any, bank_account_type: Any = ..., charge_amount: Any = ..., currency: Any = ..., description: Any = ..., input: Any = ..., min_postal_code_length: Any = ..., parameter: Any = ..., payment_connector: Any = ..., payment_method: Any = ..., postal_code: Any = ..., security_code: Any = ..., timeout: Any = ..., token_type: Any = ..., valid_card_types: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class PaymentPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class PaymentContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, call_sid: Any, sid: Any) -> None: ...
    def update(self, idempotency_key: Any, status_callback: Any, capture: Any = ..., status: Any = ...): ...

class PaymentInstance(InstanceResource):
    class PaymentMethod:
        CREDIT_CARD: str = ...
        ACH_DEBIT: str = ...
    class BankAccountType:
        CONSUMER_CHECKING: str = ...
        CONSUMER_SAVINGS: str = ...
        COMMERCIAL_CHECKING: str = ...
    class TokenType:
        ONE_TIME: str = ...
        REUSABLE: str = ...
    class Capture:
        PAYMENT_CARD_NUMBER: str = ...
        EXPIRATION_DATE: str = ...
        SECURITY_CODE: str = ...
        POSTAL_CODE: str = ...
        BANK_ROUTING_NUMBER: str = ...
        BANK_ACCOUNT_NUMBER: str = ...
    class Status:
        COMPLETE: str = ...
        CANCEL: str = ...
    def __init__(self, version: Any, payload: Any, account_sid: Any, call_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def call_sid(self): ...
    @property
    def sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def uri(self): ...
    def update(self, idempotency_key: Any, status_callback: Any, capture: Any = ..., status: Any = ...): ...
