from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class FeedbackSummaryList(ListResource):
    def __init__(self, version: Any, account_sid: Any) -> None: ...
    def create(self, start_date: Any, end_date: Any, include_subaccounts: Any = ..., status_callback: Any = ..., status_callback_method: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class FeedbackSummaryPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class FeedbackSummaryContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...

class FeedbackSummaryInstance(InstanceResource):
    class Status:
        QUEUED: str = ...
        IN_PROGRESS: str = ...
        COMPLETED: str = ...
        FAILED: str = ...
    def __init__(self, version: Any, payload: Any, account_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def call_count(self): ...
    @property
    def call_feedback_count(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def end_date(self): ...
    @property
    def include_subaccounts(self): ...
    @property
    def issues(self): ...
    @property
    def quality_score_average(self): ...
    @property
    def quality_score_median(self): ...
    @property
    def quality_score_standard_deviation(self): ...
    @property
    def sid(self): ...
    @property
    def start_date(self): ...
    @property
    def status(self): ...
    def fetch(self): ...
    def delete(self): ...
