from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class AuthorizedConnectAppList(ListResource):
    def __init__(self, version: Any, account_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, connect_app_sid: Any): ...
    def __call__(self, connect_app_sid: Any): ...

class AuthorizedConnectAppPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class AuthorizedConnectAppContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, connect_app_sid: Any) -> None: ...
    def fetch(self): ...

class AuthorizedConnectAppInstance(InstanceResource):
    class Permission:
        GET_ALL: str = ...
        POST_ALL: str = ...
    def __init__(self, version: Any, payload: Any, account_sid: Any, connect_app_sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def connect_app_company_name(self): ...
    @property
    def connect_app_description(self): ...
    @property
    def connect_app_friendly_name(self): ...
    @property
    def connect_app_homepage_url(self): ...
    @property
    def connect_app_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def permissions(self): ...
    @property
    def uri(self): ...
    def fetch(self): ...
