from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class ApplicationList(ListResource):
    def __init__(self, version: Any, account_sid: Any) -> None: ...
    def create(self, api_version: Any = ..., voice_url: Any = ..., voice_method: Any = ..., voice_fallback_url: Any = ..., voice_fallback_method: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., voice_caller_id_lookup: Any = ..., sms_url: Any = ..., sms_method: Any = ..., sms_fallback_url: Any = ..., sms_fallback_method: Any = ..., sms_status_callback: Any = ..., message_status_callback: Any = ..., friendly_name: Any = ...): ...
    def stream(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, friendly_name: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ApplicationPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ApplicationContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, sid: Any) -> None: ...
    def delete(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., api_version: Any = ..., voice_url: Any = ..., voice_method: Any = ..., voice_fallback_url: Any = ..., voice_fallback_method: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., voice_caller_id_lookup: Any = ..., sms_url: Any = ..., sms_method: Any = ..., sms_fallback_url: Any = ..., sms_fallback_method: Any = ..., sms_status_callback: Any = ..., message_status_callback: Any = ...): ...

class ApplicationInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, account_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def api_version(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def friendly_name(self): ...
    @property
    def message_status_callback(self): ...
    @property
    def sid(self): ...
    @property
    def sms_fallback_method(self): ...
    @property
    def sms_fallback_url(self): ...
    @property
    def sms_method(self): ...
    @property
    def sms_status_callback(self): ...
    @property
    def sms_url(self): ...
    @property
    def status_callback(self): ...
    @property
    def status_callback_method(self): ...
    @property
    def uri(self): ...
    @property
    def voice_caller_id_lookup(self): ...
    @property
    def voice_fallback_method(self): ...
    @property
    def voice_fallback_url(self): ...
    @property
    def voice_method(self): ...
    @property
    def voice_url(self): ...
    def delete(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., api_version: Any = ..., voice_url: Any = ..., voice_method: Any = ..., voice_fallback_url: Any = ..., voice_fallback_method: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., voice_caller_id_lookup: Any = ..., sms_url: Any = ..., sms_method: Any = ..., sms_fallback_url: Any = ..., sms_fallback_method: Any = ..., sms_status_callback: Any = ..., message_status_callback: Any = ...): ...
