from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.api.v2010.account.address.dependent_phone_number import DependentPhoneNumberList as DependentPhoneNumberList
from typing import Any, Optional

class AddressList(ListResource):
    def __init__(self, version: Any, account_sid: Any) -> None: ...
    def create(self, customer_name: Any, street: Any, city: Any, region: Any, postal_code: Any, iso_country: Any, friendly_name: Any = ..., emergency_enabled: Any = ..., auto_correct_address: Any = ...): ...
    def stream(self, customer_name: Any = ..., friendly_name: Any = ..., iso_country: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, customer_name: Any = ..., friendly_name: Any = ..., iso_country: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, customer_name: Any = ..., friendly_name: Any = ..., iso_country: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class AddressPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class AddressContext(InstanceContext):
    def __init__(self, version: Any, account_sid: Any, sid: Any) -> None: ...
    def delete(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., customer_name: Any = ..., street: Any = ..., city: Any = ..., region: Any = ..., postal_code: Any = ..., emergency_enabled: Any = ..., auto_correct_address: Any = ...): ...
    @property
    def dependent_phone_numbers(self): ...

class AddressInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, account_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def city(self): ...
    @property
    def customer_name(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def friendly_name(self): ...
    @property
    def iso_country(self): ...
    @property
    def postal_code(self): ...
    @property
    def region(self): ...
    @property
    def sid(self): ...
    @property
    def street(self): ...
    @property
    def uri(self): ...
    @property
    def emergency_enabled(self): ...
    @property
    def validated(self): ...
    @property
    def verified(self): ...
    def delete(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., customer_name: Any = ..., street: Any = ..., city: Any = ..., region: Any = ..., postal_code: Any = ..., emergency_enabled: Any = ..., auto_correct_address: Any = ...): ...
    @property
    def dependent_phone_numbers(self): ...
