INTERVALS = [1, 5, 15, 30, 60]
SOURCES = ["YahooFinance", "AlphaVantage", "EODHD"]
CANDLE_SORT = [
    "adjclose",
    "open",
    "close",
    "high",
    "low",
    "volume",
    "returns",
    "logret",
]

market_coverage_suffix = {
    "united_states": ["CBT", "CME", "NYB", "CMX", "NYM", "US", ""],
    "argentina": ["BA"],
    "austria": ["VI"],
    "australia": ["AX"],
    "belgium": ["BR"],
    "brazil": ["SA"],
    "canada": ["CN", "NE", "TO", "V"],
    "chile": ["SN"],
    "china": ["SS", "SZ"],
    "czech_republic": ["PR"],
    "denmark": ["CO"],
    "egypt": ["CA"],
    "estonia": ["TL"],
    "europe": ["NX"],
    "finland": ["HE"],
    "france": ["PA"],
    "germany": ["BE", "BM", "DU", "F", "HM", "HA", "MU", "SG", "DE"],
    "greece": ["AT"],
    "hong_kong": ["HK"],
    "hungary": ["BD"],
    "iceland": ["IC"],
    "india": ["BO", "NS"],
    "indonesia": ["JK"],
    "ireland": ["IR"],
    "israel": ["TA"],
    "italy": ["MI"],
    "japan": ["T", "S"],
    "latvia": ["RG"],
    "lithuania": ["VS"],
    "malaysia": ["KL"],
    "mexico": ["MX"],
    "netherlands": ["AS"],
    "new_zealand": ["NZ"],
    "norway": ["OL"],
    "portugal": ["LS"],
    "qatar": ["QA"],
    "russia": ["ME"],
    "singapore": ["SI"],
    "south_africa": ["JO"],
    "south_korea": ["KS", "KQ"],
    "spain": ["MC"],
    "saudi_arabia": ["SAU"],
    "sweden": ["ST"],
    "switzerland": ["SW"],
    "taiwan": ["TWO", "TW"],
    "thailand": ["BK"],
    "turkey": ["IS"],
    "united_kingdom": ["L", "IL"],
    "venezuela": ["CR"],
}

INCOME_PLOT = {
    "AlphaVantage": [
        "reported_currency",
        "gross_profit",
        "total_revenue",
        "cost_of_revenue",
        "cost_of_goods_and_services_sold",
        "operating_income",
        "selling_general_and_administrative",
        "research_and_development",
        "operating_expenses",
        "investment_income_net",
        "net_interest_income",
        "interest_income",
        "interest_expense",
        "non_interest_income",
        "other_non_operating_income",
        "depreciation",
        "depreciation_and_amortization",
        "income_before_tax",
        "income_tax_expense",
        "interest_and_debt_expense",
        "net_income_from_continuing_operations",
        "comprehensive_income_net_of_tax",
        "ebit",
        "ebitda",
        "net_income",
    ],
    "Polygon": [
        "cost_of_revenue",
        "diluted_earnings_per_share",
        "costs_and_expenses",
        "gross_profit",
        "non_operating_income_loss",
        "operating_income_loss",
        "participating_securities_distributed_and_undistributed_earnings_loss_basic",
        "income_tax_expense_benefit",
        "net_income_loss_attributable_to_parent",
        "net_income_loss",
        "income_tax_expense_benefit_deferred",
        "preferred_stock_dividends_and_other_adjustments",
        "operating_expenses",
        "income_loss_from_continuing_operations_before_tax",
        "net_income_loss_attributable_to_non_controlling_interest",
        "income_loss_from_continuing_operations_after_tax",
        "revenues",
        "net_income_loss_available_to_common_stockholders_basic",
        "benefits_costs_expenses",
        "basic_earnings_per_share",
        "interest_expense_operating",
        "income_loss_before_equity_method_investments",
    ],
    "YahooFinance": [
        "total_revenue",
        "cost_of_revenue",
        "gross_profit",
        "research_development",
        "selling_general_and_administrative",
        "total_operating_expenses",
        "operating_income_or_loss",
        "interest_expense",
        "total_other_income/expenses_net",
        "income_before_tax",
        "income_tax_expense",
        "income_from_continuing_operations",
        "net_income",
        "net_income_available_to_common_shareholders",
        "basic_eps",
        "diluted_eps",
        "basic_average_shares",
        "diluted_average_shares",
        "ebitda",
    ],
    "FinancialModelingPrep": [
        "reported_currency",
        "cik",
        "filling_date",
        "accepted_date",
        "calendar_year",
        "period",
        "revenue",
        "cost_of_revenue",
        "gross_profit",
        "gross_profit_ratio",
        "research_and_development_expenses",
        "general_and_administrative_expenses",
        "selling_and_marketing_expenses",
        "selling_general_and_administrative_expenses",
        "other_expenses",
        "operating_expenses",
        "cost_and_expenses",
        "interest_income",
        "interest_expense",
        "depreciation_and_amortization",
        "ebitda",
        "ebitda_ratio",
        "operating_income",
        "operating_income_ratio",
        "total_other_income_expenses_net",
        "income_before_tax",
        "income_before_tax_ratio",
        "income_tax_expense",
        "net_income",
        "net_income_ratio",
        "eps",
        "eps_diluted",
        "weighted_average_shs_out",
        "weighted_average_shs_out_dil",
        "link",
        "final_link",
    ],
}
BALANCE_PLOT = {
    "AlphaVantage": [
        "reported_currency",
        "total_assets",
        "total_current_assets",
        "cash_and_cash_equivalents_at_carrying_value",
        "cash_and_short_term_investments",
        "inventory",
        "current_net_receivables",
        "total_non_current_assets",
        "property_plant_equipment",
        "accumulated_depreciation_amortization_ppe",
        "intangible_assets",
        "intangible_assets_excluding_goodwill",
        "goodwill",
        "investments",
        "long_term_investments",
        "short_term_investments",
        "other_current_assets",
        "other_non_currrent_assets",
        "total_liabilities",
        "total_current_liabilities",
        "current_accounts_payable",
        "deferred_revenue",
        "current_debt",
        "short_term_debt",
        "total_non_current_liabilities",
        "capital_lease_obligations",
        "long_term_debt",
        "current_long_term_debt",
        "long_term_debt_non_current",
        "short_long_term_debt_total",
        "other_current_liabilities",
        "other_non_current_liabilities",
        "total_shareholder_equity",
        "treasury_stock",
        "retained_earnings",
        "common_stock",
        "common_stock_shares_outstanding",
    ],
    "Polygon": [
        "equity_attributable_to_non_controlling_interest",
        "liabilities",
        "non_current_assets",
        "equity",
        "assets",
        "current_assets",
        "equity_attributable_to_parent",
        "current_liabilities",
        "non_current_liabilities",
        "fixed_assets",
        "other_than_fixed_non_current_assets",
        "liabilities_and_equity",
    ],
    "YahooFinance": [
        "cash_and_cash_equivalents",
        "other_short-term_investments",
        "total_cash",
        "net_receivables",
        "inventory",
        "other_current_assets",
        "total_current_assets",
        "gross_property, plant_and_equipment",
        "accumulated_depreciation",
        "net_property, plant_and_equipment",
        "equity_and_other_investments",
        "other_long-term_assets",
        "total_non-current_assets",
        "total_assets",
        "current_debt",
        "accounts_payable",
        "deferred_revenues",
        "other_current_liabilities",
        "total_current_liabilities",
        "long-term_debt",
        "deferred_tax_liabilities",
        "deferred_revenues",
        "other_long-term_liabilities",
        "total_non-current_liabilities",
        "total_liabilities",
        "common_stock",
        "retained_earnings",
        "accumulated_other_comprehensive_income",
        "total_stockholders'_equity",
        "total_liabilities_and_stockholders'_equity",
    ],
    "FinancialModelingPrep": [
        "reported_currency",
        "cik",
        "filling_date",
        "accepted_date",
        "calendar_year",
        "period",
        "cash_and_cash_equivalents",
        "short_term_investments",
        "cash_and_short_term_investments",
        "net_receivables",
        "inventory",
        "other_current_assets",
        "total_current_assets",
        "property_plant_equipment_net",
        "goodwill",
        "intangible_assets",
        "goodwill_and_intangible_assets",
        "long_term_investments",
        "tax_assets",
        "other_non_current_assets",
        "total_non_current_assets",
        "other_assets",
        "total_assets",
        "account_payables",
        "short_term_debt",
        "tax_payables",
        "deferred_revenue",
        "other_current_liabilities",
        "total_current_liabilities",
        "long_term_debt",
        "deferred_revenue_non_current",
        "deferred_tax_liabilities_non_current",
        "other_non_current_liabilities",
        "total_non_current_liabilities",
        "other_liabilities",
        "capital_lease_obligations",
        "total_liabilities",
        "preferred_stock",
        "common_stock",
        "retained_earnings",
        "accumulated_other_comprehensive_income_loss",
        "other_total_stockholders_equity",
        "total_stockholders_equity",
        "total_liabilities_and_stockholders_equity",
        "minority_interest",
        "total_equity",
        "total_liabilities_and_total_equity",
        "total_investments",
        "total_debt",
        "net_debt",
        "link",
        "final_link",
    ],
}
CASH_PLOT = {
    "AlphaVantage": [
        "reported_currency",
        "operating_cash_flow",
        "payments_for_operating_activities",
        "proceeds_from_operating_activities",
        "change_in_operating_liabilities",
        "change_in_operating_assets",
        "depreciation_depletion_and_amortization",
        "capital_expenditures",
        "change_in_receivables",
        "change_in_inventory",
        "profit_loss",
        "cash_flow_from_investment",
        "cash_flow_from_financing",
        "proceeds_from_repayments_of_short_term_debt",
        "payments_for_repurchase_of_common_stock",
        "payments_for_repurchase_of_equity",
        "payments_for_repurchase_of_preferred_stock",
        "dividend_payout",
        "dividend_payout_common_stock",
        "dividend_payout_preferred_stock",
        "proceeds_from_issuance_of_common_stock",
        "proceeds_from_issuance_of_long_term_debt_and_capital_securities_net",
        "proceeds_from_issuance_of_preferred_stock",
        "proceeds_from_repurchase_of_equity",
        "proceeds_from_sale_of_treasury_stock",
        "change_in_cash_and_cash_equivalents",
        "change_in_exchange_rate",
        "net_income",
    ],
    "Polygon": [
        "net_cash_flow_from_financing_activities_continuing",
        "net_cash_flow_continuing",
        "net_cash_flow_from_investing_activities",
        "net_cash_flow",
        "net_cash_flow_from_operating_activities",
        "net_cash_flow_from_financing_activities",
        "net_cash_flow_from_operating_activities_continuing",
        "net_cash_flow_from_investing_activities_continuing",
    ],
    "YahooFinance": [
        "net_income",
        "depreciation_&_amortisation",
        "deferred_income_taxes",
        "stock-based_compensation",
        "change_in working_capital",
        "accounts_receivable",
        "inventory",
        "accounts_payable",
        "other_working_capital",
        "other_non-cash_items",
        "net_cash_provided_by_operating_activities",
        "investments_in_property, plant_and_equipment",
        "acquisitions, net",
        "purchases_of_investments",
        "sales/maturities_of_investments",
        "other_investing_activities",
        "net_cash_used_for_investing_activities",
        "debt_repayment",
        "common_stock_issued",
        "common_stock_repurchased",
        "dividends_paid",
        "other_financing_activities",
        "net_cash_used_provided_by_(used_for)_financing_activities",
        "net_change_in_cash",
        "cash_at_beginning_of_period",
        "cash_at_end_of_period",
        "operating_cash_flow",
        "capital_expenditure",
        "free_cash_flow",
    ],
    "FinancialModelingPrep": [
        "reported_currency",
        "cik",
        "filling_date",
        "accepted_date",
        "calendar_year",
        "period",
        "net_income",
        "depreciation_and_amortization",
        "deferred_income_tax",
        "stock_based_compensation",
        "change_in_working_capital",
        "accounts_receivables",
        "inventory",
        "accounts_payables",
        "other_working_capital",
        "other_non_cash_items",
        "net_cash_provided_by_operating_activities",
        "investments_in_property_plant_and_equipment",
        "acquisitions_net",
        "purchases_of_investments",
        "sales_maturities_of_investments",
        "other_investing_activites",
        "net_cash_used_for_investing_activites",
        "debt_repayment",
        "common_stock_issued",
        "common_stock_repurchased",
        "dividends_paid",
        "other_financing_activites",
        "net_cash_used_provided_by_financing_activities",
        "effect_of_forex_changes_on_cash",
        "net_change_in_cash",
        "cash_at_end_of_period",
        "cash_at_beginning_of_period",
        "operating_cash_flow",
        "capital_expenditure",
        "free_cash_flow",
        "link",
        "final_link",
    ],
}
