from setuptools import setup, find_packages

with open("README.md") as f:
    _long_description = f.read()


setup(
    name="helax",
    version="0.1.1",
    description="Package for computing helicity amplitudes using NumPy or Jax.",
    long_description=_long_description,
    long_description_content_type="text/markdown",
    author="Logan A. Morrison",
    author_email="loganmorrison99@gmail.com",
    packages=find_packages(exclude=["notebooks", "old", "test"]),
    package_data={},
    python_requires=">=3.8",
    install_requires=["numpy>=1.20"],
    extras_require={"jax": ["jax>=0.3.4", "jaxlib>=0.3.2", "chex>=0.1"]},
    keywords=["high-energy-physics", "quantum-field-theory"],
    zip_safe=True,
    classifiers=[
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
    ],
)
