/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverInfo;
import utils.RuntimeEnvInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0012\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u000bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0003\u0010\u0005R\u001b\u0010\b\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\u0007\u001a\u0004\b\b\u0010\u0005R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lutils/RuntimeEnvInfo;", "", "()V", "isPrlimitCommandAvailable", "", "()Z", "isPrlimitCommandAvailable$delegate", "Lkotlin/Lazy;", "isTimeoutCommandAvailable", "isTimeoutCommandAvailable$delegate", "prlimitCommand", "", "simpleCommandTimeoutSeconds", "", "timeoutCommand", "timeoutCommandDefaultTimeoutSeconds", "getCommandOutput", "cmd", "", "([Ljava/lang/String;)Ljava/lang/String;", "getPrlimitCommandIfAvailable", "", "memLimitBytes", "(Ljava/lang/Long;)Ljava/util/List;", "getSolverVersionIfAvailable", "solver", "Lsolver/SolverInfo;", "versionFlag", "getTimeoutCommandIfAvailable", "timeout", "Ljava/time/Duration;", "GeneralUtils"})
public final class RuntimeEnvInfo {
    @NotNull
    public static final RuntimeEnvInfo INSTANCE = new RuntimeEnvInfo();
    private static final long timeoutCommandDefaultTimeoutSeconds = 600L;
    private static final long simpleCommandTimeoutSeconds = 3L;
    @NotNull
    public static final String timeoutCommand = "timeout";
    @NotNull
    private static final Lazy isTimeoutCommandAvailable$delegate = LazyKt.lazy(isTimeoutCommandAvailable.2.INSTANCE);
    @NotNull
    public static final String prlimitCommand = "prlimit";
    @NotNull
    private static final Lazy isPrlimitCommandAvailable$delegate = LazyKt.lazy(isPrlimitCommandAvailable.2.INSTANCE);

    private RuntimeEnvInfo() {
    }

    private final String getCommandOutput(String ... cmd) {
        int n;
        Process process2;
        try {
            process2 = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            return null;
        }
        Process proc = process2;
        InputStream e = proc.getInputStream();
        Intrinsics.checkNotNullExpressionValue(e, "proc.inputStream");
        Object object = Charsets.UTF_8;
        Closeable closeable = e;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n2 = 8192;
        BufferedReader procOutput = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        try {
            proc.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            return null;
        }
        List output = new ArrayList();
        try {
            while (procOutput.ready()) {
                object = procOutput.readLine();
                Intrinsics.checkNotNullExpressionValue(object, "procOutput.readLine()");
                output.add(object);
            }
        }
        catch (IOException e2) {
            return null;
        }
        try {
            n = proc.exitValue();
        }
        catch (IllegalThreadStateException e3) {
            proc.destroyForcibly();
            return null;
        }
        int exitVal = n;
        return exitVal == 0 ? CollectionsKt.joinToString$default(output, "\n", null, null, 0, null, null, 62, null) : (String)null;
    }

    @Nullable
    public final String getSolverVersionIfAvailable(@NotNull SolverInfo solver, @NotNull String versionFlag) {
        Intrinsics.checkNotNullParameter(solver, "solver");
        Intrinsics.checkNotNullParameter(versionFlag, "versionFlag");
        String[] stringArray = new String[]{solver.getDefaultCommand(), versionFlag};
        return this.getCommandOutput(stringArray);
    }

    public static /* synthetic */ String getSolverVersionIfAvailable$default(RuntimeEnvInfo runtimeEnvInfo, SolverInfo solverInfo, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "--version";
        }
        return runtimeEnvInfo.getSolverVersionIfAvailable(solverInfo, string2);
    }

    public final boolean isTimeoutCommandAvailable() {
        Lazy lazy = isTimeoutCommandAvailable$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final List<String> getTimeoutCommandIfAvailable(@Nullable Duration timeout) {
        List<String> list2;
        if (this.isTimeoutCommandAvailable()) {
            long l;
            String[] stringArray = new String[4];
            stringArray[0] = timeoutCommand;
            stringArray[1] = "-k";
            stringArray[2] = "3s";
            Duration duration = timeout;
            stringArray[3] = String.valueOf((duration == null ? 600L : (l = duration.toSeconds())) + (long)3);
            list2 = CollectionsKt.listOf(stringArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final boolean isPrlimitCommandAvailable() {
        Lazy lazy = isPrlimitCommandAvailable$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final List<String> getPrlimitCommandIfAvailable(@Nullable Long memLimitBytes) {
        List<String> list2;
        if (memLimitBytes != null && this.isPrlimitCommandAvailable()) {
            if (!(memLimitBytes >= 0L)) {
                boolean bl = false;
                String string2 = "a negative value for memlimit will be ignored";
                throw new IllegalStateException(string2.toString());
            }
            String[] stringArray = new String[]{prlimitCommand, "--as=" + memLimitBytes};
            list2 = CollectionsKt.listOf(stringArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public static final /* synthetic */ String access$getCommandOutput(RuntimeEnvInfo $this, String ... cmd) {
        return $this.getCommandOutput(cmd);
    }
}

