/*
 * Decompiled with CFR 0.152.
 */
package tac;

import datastructures.stdcollections.ListsKt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tac.Tag;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\t\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\u0015\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Ltac/Tag;", "Ljava/io/Serializable;", "()V", "nestedBasicTagsFlat", "Lkotlin/sequences/Sequence;", "getNestedBasicTagsFlat", "()Lkotlin/sequences/Sequence;", "isPrimitive", "", "isTranslatedToSmtInt", "toString", "", "Bit256", "Bool", "ByteMap", "DoubleMap", "GhostMap", "Int", "Map", "UserDefined", "WordMap", "Ltac/Tag$Bit256;", "Ltac/Tag$Bool;", "Ltac/Tag$Map;", "Ltac/Tag$Int;", "Ltac/Tag$UserDefined;", "Shared"})
public abstract class Tag
implements Serializable {
    private Tag() {
    }

    @NotNull
    public Sequence<Tag> getNestedBasicTagsFlat() {
        Tag[] tagArray = new Tag[]{this};
        return SequencesKt.sequenceOf(tagArray);
    }

    @NotNull
    public String toString() {
        Object object;
        Tag tag2 = this;
        if (Intrinsics.areEqual(tag2, Bit256.INSTANCE)) {
            object = "bv256";
        } else if (Intrinsics.areEqual(tag2, Bool.INSTANCE)) {
            object = "bool";
        } else if (Intrinsics.areEqual(tag2, ByteMap.INSTANCE)) {
            object = "bytemap";
        } else if (Intrinsics.areEqual(tag2, WordMap.INSTANCE)) {
            object = "wordmap";
        } else if (Intrinsics.areEqual(tag2, DoubleMap.INSTANCE)) {
            object = "doublemap";
        } else if (Intrinsics.areEqual(tag2, Int.INSTANCE)) {
            object = "int";
        } else if (tag2 instanceof UserDefined) {
            object = this.toString();
        } else if (tag2 instanceof GhostMap) {
            object = "ghostmap(" + CollectionsKt.joinToString$default(((GhostMap)this).getParamSorts(), "*", null, null, 0, null, null, 62, null) + "->" + ((GhostMap)this).getResultSort() + ")";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public final boolean isTranslatedToSmtInt() {
        return Intrinsics.areEqual(this, Int.INSTANCE) || Intrinsics.areEqual(this, Bit256.INSTANCE);
    }

    public final boolean isPrimitive() {
        return Intrinsics.areEqual(this, Int.INSTANCE) || Intrinsics.areEqual(this, Bit256.INSTANCE) || Intrinsics.areEqual(this, Bool.INSTANCE);
    }

    public /* synthetic */ Tag(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ltac/Tag$Bit256;", "Ltac/Tag;", "()V", "readResolve", "", "Shared"})
    public static final class Bit256
    extends Tag {
        @NotNull
        public static final Bit256 INSTANCE = new Bit256();

        private Bit256() {
            super(null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ltac/Tag$Bool;", "Ltac/Tag;", "()V", "readResolve", "", "Shared"})
    public static final class Bool
    extends Tag {
        @NotNull
        public static final Bool INSTANCE = new Bool();

        private Bool() {
            super(null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0004\u0011\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Ltac/Tag$Map;", "Ltac/Tag;", "()V", "nestedBasicTagsFlat", "Lkotlin/sequences/Sequence;", "getNestedBasicTagsFlat", "()Lkotlin/sequences/Sequence;", "paramSorts", "", "getParamSorts", "()Ljava/util/List;", "resultSort", "getResultSort", "()Ltac/Tag;", "getMapDimension", "", "Companion", "Ltac/Tag$ByteMap;", "Ltac/Tag$WordMap;", "Ltac/Tag$DoubleMap;", "Ltac/Tag$GhostMap;", "Shared"})
    public static abstract class Map
    extends Tag {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private Map() {
            super(null);
        }

        @NotNull
        public abstract List<Tag> getParamSorts();

        @NotNull
        public abstract Tag getResultSort();

        @Override
        @NotNull
        public Sequence<Tag> getNestedBasicTagsFlat() {
            return SequencesKt.plus(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.getParamSorts()), nestedBasicTagsFlat.1.INSTANCE), this.getResultSort().getNestedBasicTagsFlat());
        }

        public final int getMapDimension() {
            return this.getParamSorts().size();
        }

        public /* synthetic */ Map(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Ltac/Tag$Map$Companion;", "", "()V", "fromSignature", "Ltac/Tag$Map;", "paramSorts", "", "Ltac/Tag;", "resultSort", "isWordMap", "", "Shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map fromSignature(@NotNull List<? extends Tag> paramSorts, @NotNull Tag resultSort, boolean isWordMap) {
                Map map2;
                Intrinsics.checkNotNullParameter(paramSorts, "paramSorts");
                Intrinsics.checkNotNullParameter(resultSort, "resultSort");
                switch (paramSorts.size()) {
                    case 0: {
                        throw new IllegalArgumentException("can't build a proper map type without parameter sorts (got result sort " + resultSort + ") ");
                    }
                    case 1: {
                        if (paramSorts.get(0) instanceof Bit256) {
                            if (isWordMap) {
                                map2 = WordMap.INSTANCE;
                                break;
                            }
                            map2 = ByteMap.INSTANCE;
                            break;
                        }
                        if (!(!isWordMap)) {
                            boolean bl = false;
                            String string2 = "isWordMap is set, but signature (" + CollectionsKt.joinToString$default(paramSorts, " x ", null, null, 0, null, null, 62, null) + " -> " + resultSort + "} does not match";
                            throw new IllegalStateException(string2.toString());
                        }
                        map2 = new GhostMap(paramSorts, resultSort);
                        break;
                    }
                    default: {
                        if (!(!isWordMap)) {
                            boolean bl = false;
                            String string3 = "isWordMap is set, but signature does not match";
                            throw new IllegalStateException(string3.toString());
                        }
                        map2 = new GhostMap(paramSorts, resultSort);
                    }
                }
                return map2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Ltac/Tag$ByteMap;", "Ltac/Tag$Map;", "()V", "paramSorts", "", "Ltac/Tag;", "getParamSorts", "()Ljava/util/List;", "resultSort", "getResultSort", "()Ltac/Tag;", "readResolve", "", "Shared"})
    public static final class ByteMap
    extends Map {
        @NotNull
        public static final ByteMap INSTANCE = new ByteMap();

        private ByteMap() {
            super(null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public List<Tag> getParamSorts() {
            return ListsKt.listOf(Bit256.INSTANCE);
        }

        @Override
        @NotNull
        public Tag getResultSort() {
            return Bit256.INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Ltac/Tag$WordMap;", "Ltac/Tag$Map;", "()V", "paramSorts", "", "Ltac/Tag;", "getParamSorts", "()Ljava/util/List;", "resultSort", "getResultSort", "()Ltac/Tag;", "readResolve", "", "Shared"})
    public static final class WordMap
    extends Map {
        @NotNull
        public static final WordMap INSTANCE = new WordMap();

        private WordMap() {
            super(null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public List<Tag> getParamSorts() {
            return ListsKt.listOf(Bit256.INSTANCE);
        }

        @Override
        @NotNull
        public Tag getResultSort() {
            return Bit256.INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Ltac/Tag$DoubleMap;", "Ltac/Tag$Map;", "()V", "paramSorts", "", "Ltac/Tag;", "getParamSorts", "()Ljava/util/List;", "resultSort", "getResultSort", "()Ltac/Tag;", "readResolve", "", "Shared"})
    public static final class DoubleMap
    extends Map {
        @NotNull
        public static final DoubleMap INSTANCE = new DoubleMap();

        private DoubleMap() {
            super(null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        @Override
        @NotNull
        public List<Tag> getParamSorts() {
            return ListsKt.listOf(Bit256.INSTANCE, Bit256.INSTANCE);
        }

        @Override
        @NotNull
        public Tag getResultSort() {
            return Bit256.INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ltac/Tag$Int;", "Ltac/Tag;", "()V", "readResolve", "", "Shared"})
    public static final class Int
    extends Tag {
        @NotNull
        public static final Int INSTANCE = new Int();

        private Int() {
            super(null);
        }

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Ltac/Tag$GhostMap;", "Ltac/Tag$Map;", "paramSorts", "", "Ltac/Tag;", "resultSort", "(Ljava/util/List;Ltac/Tag;)V", "getParamSorts", "()Ljava/util/List;", "getResultSort", "()Ltac/Tag;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "Shared"})
    public static final class GhostMap
    extends Map {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Tag> paramSorts;
        @NotNull
        private final Tag resultSort;
        @NotNull
        public static final String namePrefix = "ghostmap";
        @NotNull
        public static final String cross = "*";
        @NotNull
        public static final String arrow = "->";

        public GhostMap(@NotNull List<? extends Tag> paramSorts, @NotNull Tag resultSort) {
            Intrinsics.checkNotNullParameter(paramSorts, "paramSorts");
            Intrinsics.checkNotNullParameter(resultSort, "resultSort");
            super(null);
            this.paramSorts = paramSorts;
            this.resultSort = resultSort;
            if (!(!((Collection)this.getParamSorts()).isEmpty())) {
                boolean bl = false;
                String string2 = "Cannot construct Tag.GhostMap with empty list of parameter Tags";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        @Override
        @NotNull
        public List<Tag> getParamSorts() {
            return this.paramSorts;
        }

        @Override
        @NotNull
        public Tag getResultSort() {
            return this.resultSort;
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString();
        }

        @NotNull
        public final List<Tag> component1() {
            return this.getParamSorts();
        }

        @NotNull
        public final Tag component2() {
            return this.getResultSort();
        }

        @NotNull
        public final GhostMap copy(@NotNull List<? extends Tag> paramSorts, @NotNull Tag resultSort) {
            Intrinsics.checkNotNullParameter(paramSorts, "paramSorts");
            Intrinsics.checkNotNullParameter(resultSort, "resultSort");
            return new GhostMap(paramSorts, resultSort);
        }

        public static /* synthetic */ GhostMap copy$default(GhostMap ghostMap, List list2, Tag tag2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = ghostMap.getParamSorts();
            }
            if ((n & 2) != 0) {
                tag2 = ghostMap.getResultSort();
            }
            return ghostMap.copy(list2, tag2);
        }

        public int hashCode() {
            int result2 = ((Object)this.getParamSorts()).hashCode();
            result2 = result2 * 31 + this.getResultSort().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GhostMap)) {
                return false;
            }
            GhostMap ghostMap = (GhostMap)other;
            if (!Intrinsics.areEqual(this.getParamSorts(), ghostMap.getParamSorts())) {
                return false;
            }
            return Intrinsics.areEqual(this.getResultSort(), ghostMap.getResultSort());
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ltac/Tag$GhostMap$Companion;", "", "()V", "arrow", "", "cross", "namePrefix", "Shared"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Ltac/Tag$UserDefined;", "Ltac/Tag;", "()V", "decl", "", "getDecl", "()Ljava/lang/String;", "Struct", "UninterpretedSort", "Ltac/Tag$UserDefined$UninterpretedSort;", "Ltac/Tag$UserDefined$Struct;", "Shared"})
    public static abstract class UserDefined
    extends Tag {
        private UserDefined() {
            super(null);
        }

        @NotNull
        public abstract String getDecl();

        public /* synthetic */ UserDefined(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ltac/Tag$UserDefined$UninterpretedSort;", "Ltac/Tag$UserDefined;", "name", "", "(Ljava/lang/String;)V", "decl", "getDecl", "()Ljava/lang/String;", "getName", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
        public static final class UninterpretedSort
        extends UserDefined {
            @NotNull
            private final String name;
            @NotNull
            private final String decl;

            public UninterpretedSort(@NotNull String name) {
                Intrinsics.checkNotNullParameter(name, "name");
                super(null);
                this.name = name;
                this.decl = "UninterpSort " + this.name;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            @NotNull
            public String getDecl() {
                return this.decl;
            }

            @Override
            @NotNull
            public String toString() {
                return "(uninterp) " + this.name;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final UninterpretedSort copy(@NotNull String name) {
                Intrinsics.checkNotNullParameter(name, "name");
                return new UninterpretedSort(name);
            }

            public static /* synthetic */ UninterpretedSort copy$default(UninterpretedSort uninterpretedSort, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = uninterpretedSort.name;
                }
                return uninterpretedSort.copy(string2);
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UninterpretedSort)) {
                    return false;
                }
                UninterpretedSort uninterpretedSort = (UninterpretedSort)other;
                return Intrinsics.areEqual(this.name, uninterpretedSort.name);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u001b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J#\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0007J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u0007H\u0016R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001d"}, d2={"Ltac/Tag$UserDefined$Struct;", "Ltac/Tag$UserDefined;", "fields", "", "Ltac/Tag$UserDefined$Struct$Field;", "(Ljava/util/List;)V", "name", "", "(Ljava/lang/String;Ljava/util/List;)V", "decl", "getDecl", "()Ljava/lang/String;", "getFields", "()Ljava/util/List;", "getName", "component1", "component2", "containsField", "", "fieldName", "copy", "equals", "other", "", "getField", "hashCode", "", "toString", "Field", "Shared"})
        public static final class Struct
        extends UserDefined {
            @NotNull
            private final String name;
            @NotNull
            private final List<Field> fields;
            @NotNull
            private final String decl;

            public Struct(@NotNull String name, @NotNull List<Field> fields) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(fields, "fields");
                super(null);
                this.name = name;
                this.fields = fields;
                Iterable $this$distinctBy$iv = this.fields;
                boolean $i$f$distinctBy = false;
                HashSet<String> set$iv = new HashSet<String>();
                ArrayList list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    Field field = (Field)e$iv;
                    boolean bl = false;
                    String key$iv = field.getName();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                if (!(((List)list$iv).size() == this.fields.size())) {
                    boolean bl = false;
                    String string2 = "Impossible to construct struct " + this.getName() + ": contains duplicate fields (fields: " + this.getFields() + ")";
                    throw new IllegalStateException(string2.toString());
                }
                this.decl = "Struct " + this.name + " {" + CollectionsKt.joinToString$default(this.fields, ", ", null, null, 0, null, decl.1.INSTANCE, 30, null) + "}";
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final List<Field> getFields() {
                return this.fields;
            }

            public Struct(@NotNull List<Field> fields) {
                Intrinsics.checkNotNullParameter(fields, "fields");
                this("unnamed struct", fields);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean containsField(@NotNull String fieldName) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(fieldName, "fieldName");
                Iterable $this$map$iv = this.fields;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void field;
                    Field field2 = (Field)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(field.getName());
                }
                return ((List)destination$iv$iv).contains(fieldName);
            }

            @Nullable
            public final Field getField(@NotNull String fieldName) {
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter(fieldName, "fieldName");
                    Iterable $this$singleOrNull$iv = this.fields;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        Field field = (Field)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(field.getName(), fieldName)) continue;
                        if (found$iv) {
                            v0 = null;
                            break block2;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v0 = !found$iv ? null : single$iv;
                }
                return v0;
            }

            @Override
            @NotNull
            public String toString() {
                return this.name;
            }

            @Override
            @NotNull
            public String getDecl() {
                return this.decl;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final List<Field> component2() {
                return this.fields;
            }

            @NotNull
            public final Struct copy(@NotNull String name, @NotNull List<Field> fields) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(fields, "fields");
                return new Struct(name, fields);
            }

            public static /* synthetic */ Struct copy$default(Struct struct, String string2, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = struct.name;
                }
                if ((n & 2) != 0) {
                    list2 = struct.fields;
                }
                return struct.copy(string2, list2);
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + ((Object)this.fields).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Struct)) {
                    return false;
                }
                Struct struct = (Struct)other;
                if (!Intrinsics.areEqual(this.name, struct.name)) {
                    return false;
                }
                return Intrinsics.areEqual(this.fields, struct.fields);
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ltac/Tag$UserDefined$Struct$Field;", "Ljava/io/Serializable;", "name", "", "type", "Ltac/Tag;", "(Ljava/lang/String;Ltac/Tag;)V", "getName", "()Ljava/lang/String;", "getType", "()Ltac/Tag;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
            public static final class Field
            implements Serializable {
                @NotNull
                private final String name;
                @NotNull
                private final Tag type;

                public Field(@NotNull String name, @NotNull Tag type) {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Intrinsics.checkNotNullParameter(type, "type");
                    this.name = name;
                    this.type = type;
                }

                @NotNull
                public final String getName() {
                    return this.name;
                }

                @NotNull
                public final Tag getType() {
                    return this.type;
                }

                @NotNull
                public final String component1() {
                    return this.name;
                }

                @NotNull
                public final Tag component2() {
                    return this.type;
                }

                @NotNull
                public final Field copy(@NotNull String name, @NotNull Tag type) {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Intrinsics.checkNotNullParameter(type, "type");
                    return new Field(name, type);
                }

                public static /* synthetic */ Field copy$default(Field field, String string2, Tag tag2, int n, Object object) {
                    if ((n & 1) != 0) {
                        string2 = field.name;
                    }
                    if ((n & 2) != 0) {
                        tag2 = field.type;
                    }
                    return field.copy(string2, tag2);
                }

                @NotNull
                public String toString() {
                    return "Field(name=" + this.name + ", type=" + this.type + ")";
                }

                public int hashCode() {
                    int result2 = this.name.hashCode();
                    result2 = result2 * 31 + this.type.hashCode();
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Field)) {
                        return false;
                    }
                    Field field = (Field)other;
                    if (!Intrinsics.areEqual(this.name, field.name)) {
                        return false;
                    }
                    return Intrinsics.areEqual(this.type, field.type);
                }
            }
        }
    }
}

