/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.CommonSolverClOptions;
import solver.SolverConfig;
import solver.SolverInfo;
import solver.SolverInfoClOptions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lsolver/Z3SolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_Z3_COMMAND", "", "alwaysOnOptions", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "randomSeed", "", "(Ljava/lang/String;Ljava/time/Duration;ZLjava/lang/Integer;)Ljava/util/List;", "getProcessTimeoutString", "getQueryRandomSeedString", "getQueryTimeoutString", "needsLogicALL", "features", "Lsolver/SolverConfig$LogicFeatures;", "plainConfig", "Lsolver/SolverConfig;", "extraClOptions", "supportsLogicFeatures", "ClOptions", "GeneralUtils"})
public final class Z3SolverInfo
extends SolverInfo {
    @NotNull
    public static final Z3SolverInfo INSTANCE = new Z3SolverInfo();
    @NotNull
    private static final List<String> alwaysOnOptions = CollectionsKt.listOf("-st");
    @NotNull
    private static final String DEFAULT_Z3_COMMAND = "z3";

    private Z3SolverInfo() {
        super("Z3");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf("-T:" + timeout.toSeconds());
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf("-t:" + timeout.toMillis());
    }

    @Override
    @NotNull
    public List<String> getQueryRandomSeedString(int randomSeed) {
        String[] stringArray = new String[]{"smt.random_seed=" + randomSeed, "sat.random_seed=" + randomSeed, "sat.phase=random", "smt.phase_selection=5"};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    public boolean needsLogicALL(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return features.getUsesDatatypes();
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode, @Nullable Integer randomSeed) {
        String[] stringArray = new String[2];
        String string2 = customSolverExecutable;
        if (string2 == null) {
            string2 = DEFAULT_Z3_COMMAND;
        }
        stringArray[0] = string2;
        stringArray[1] = "-in";
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)(timeout != null ? this.getQueryTimeoutString(timeout) : CollectionsKt.emptyList())), (Iterable)(randomSeed != null ? this.getQueryRandomSeedString(randomSeed) : CollectionsKt.emptyList())), (Iterable)alwaysOnOptions);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_Z3_COMMAND;
    }

    @NotNull
    public final SolverConfig plainConfig(@NotNull Duration timeout, boolean incrementalMode, @NotNull List<String> extraClOptions) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        Intrinsics.checkNotNullParameter(extraClOptions, "extraClOptions");
        return new SolverConfig(INSTANCE, timeout, null, incrementalMode, extraClOptions, null, null, null, null, 480, null);
    }

    public static /* synthetic */ SolverConfig plainConfig$default(Z3SolverInfo z3SolverInfo, Duration duration, boolean bl, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return z3SolverInfo.plainConfig(duration, bl, list2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lsolver/Z3SolverInfo$ClOptions;", "", "Lsolver/SolverInfoClOptions;", "(Ljava/lang/String;I)V", "randomSeed", "", "getRandomSeed", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "solverInfo", "Lsolver/Z3SolverInfo;", "getSolverInfo", "()Lsolver/Z3SolverInfo;", "Default", "Lia1", "Lia2", "Eq1", "Eq2", "GeneralUtils"})
    public static final abstract class ClOptions
    extends Enum<ClOptions>
    implements SolverInfoClOptions {
        @NotNull
        private final Z3SolverInfo solverInfo = INSTANCE;
        @Nullable
        private final Integer randomSeed;
        public static final /* enum */ ClOptions Default = new Default("Default", 0);
        public static final /* enum */ ClOptions Lia1 = new Lia1("Lia1", 1);
        public static final /* enum */ ClOptions Lia2 = new Lia2("Lia2", 2);
        public static final /* enum */ ClOptions Eq1 = new Eq1("Eq1", 3);
        public static final /* enum */ ClOptions Eq2 = new Eq2("Eq2", 4);
        private static final /* synthetic */ ClOptions[] $VALUES;

        private ClOptions() {
        }

        @Override
        @NotNull
        public Z3SolverInfo getSolverInfo() {
            return this.solverInfo;
        }

        @Override
        @Nullable
        public Integer getRandomSeed() {
            return this.randomSeed;
        }

        @Override
        @NotNull
        public String getClFullName() {
            return SolverInfoClOptions.DefaultImpls.getClFullName(this);
        }

        @Override
        @NotNull
        public CommonSolverClOptions getCommonSolverClOptions() {
            return SolverInfoClOptions.DefaultImpls.getCommonSolverClOptions(this);
        }

        public static ClOptions[] values() {
            return (ClOptions[])$VALUES.clone();
        }

        public static ClOptions valueOf(String value) {
            return Enum.valueOf(ClOptions.class, value);
        }

        public /* synthetic */ ClOptions(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = clOptionsArray = new ClOptions[]{ClOptions.Default, ClOptions.Lia1, ClOptions.Lia2, ClOptions.Eq1, ClOptions.Eq2};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/Z3SolverInfo$ClOptions$Default;", "Lsolver/Z3SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Default
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions = CollectionsKt.emptyList();

            /*
             * WARNING - void declaration
             */
            Default() {
                void var1_1;
                this.clVariantName = "def";
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return true;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/Z3SolverInfo$ClOptions$Lia1;", "Lsolver/Z3SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Lia1
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions;

            /*
             * WARNING - void declaration
             */
            Lia1() {
                void var1_1;
                this.clVariantName = "lia1";
                String[] stringArray = new String[]{"smt.arith.solver=2", "smt.auto_config=false"};
                this.clOptions = CollectionsKt.listOf(stringArray);
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return logicFeatures.getArithmeticOperations() == SolverConfig.ArithmeticOperations.LinearOnly;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/Z3SolverInfo$ClOptions$Lia2;", "Lsolver/Z3SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Lia2
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions;

            /*
             * WARNING - void declaration
             */
            Lia2() {
                void var1_1;
                this.clVariantName = "lia2";
                String[] stringArray = new String[]{"tactic.solve_eqs.max_occs=4", "smt.arith.solver=2", "smt.auto_config=false"};
                this.clOptions = CollectionsKt.listOf(stringArray);
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return logicFeatures.getArithmeticOperations() == SolverConfig.ArithmeticOperations.LinearOnly;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/Z3SolverInfo$ClOptions$Eq1;", "Lsolver/Z3SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Eq1
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions = CollectionsKt.listOf("tactic.solve_eqs.max_occs=4");

            /*
             * WARNING - void declaration
             */
            Eq1() {
                void var1_1;
                this.clVariantName = "eq1";
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return true;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/Z3SolverInfo$ClOptions$Eq2;", "Lsolver/Z3SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Eq2
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions;

            /*
             * WARNING - void declaration
             */
            Eq2() {
                void var1_1;
                this.clVariantName = "eq2";
                String[] stringArray = new String[]{"tactic.solve_eqs.max_occs=4", "tactic.solve_eqs.context_solve=true"};
                this.clOptions = CollectionsKt.listOf(stringArray);
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return true;
            }
        }
    }
}

