/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.CommonSolverClOptions;
import solver.SolverConfig;
import solver.SolverInfo;
import solver.SolverInfoClOptions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lsolver/VampireSolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_VAMPIRE_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "randomSeed", "", "(Ljava/lang/String;Ljava/time/Duration;ZLjava/lang/Integer;)Ljava/util/List;", "getProcessTimeoutString", "getQueryRandomSeedString", "getQueryTimeoutString", "supportsLogicFeatures", "features", "Lsolver/SolverConfig$LogicFeatures;", "ClOptions", "GeneralUtils"})
public final class VampireSolverInfo
extends SolverInfo {
    @NotNull
    public static final VampireSolverInfo INSTANCE = new VampireSolverInfo();
    @NotNull
    private static final String DEFAULT_VAMPIRE_COMMAND = "vprover";

    private VampireSolverInfo() {
        super("Vampire");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        String[] stringArray = new String[]{"--time_limit", String.valueOf(timeout.toSeconds())};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        String[] stringArray = new String[]{"--time_limit", String.valueOf(timeout.toSeconds())};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    @NotNull
    public List<String> getQueryRandomSeedString(int randomSeed) {
        return CollectionsKt.listOf("--random_seed " + randomSeed);
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode, @Nullable Integer randomSeed) {
        if (!(!incrementalMode)) {
            boolean bl = false;
            throw new UnsupportedOperationException("incremental mode is not supported by Vampire");
        }
        String[] stringArray = new String[11];
        String string2 = customSolverExecutable;
        if (string2 == null) {
            string2 = DEFAULT_VAMPIRE_COMMAND;
        }
        stringArray[0] = string2;
        stringArray[1] = "--input_syntax";
        stringArray[2] = "smtlib2";
        stringArray[3] = "--mode";
        stringArray[4] = "portfolio";
        stringArray[5] = "--schedule";
        stringArray[6] = "smtcomp";
        stringArray[7] = "--cores";
        stringArray[8] = "1";
        stringArray[9] = "--output_mode";
        stringArray[10] = "smtcomp";
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)(timeout != null ? this.getQueryTimeoutString(timeout) : CollectionsKt.emptyList())), (Iterable)(randomSeed != null ? this.getQueryRandomSeedString(randomSeed) : CollectionsKt.emptyList()));
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_VAMPIRE_COMMAND;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lsolver/VampireSolverInfo$ClOptions;", "", "Lsolver/SolverInfoClOptions;", "(Ljava/lang/String;I)V", "randomSeed", "", "getRandomSeed", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "solverInfo", "Lsolver/VampireSolverInfo;", "getSolverInfo", "()Lsolver/VampireSolverInfo;", "Default", "GeneralUtils"})
    public static final abstract class ClOptions
    extends Enum<ClOptions>
    implements SolverInfoClOptions {
        @NotNull
        private final VampireSolverInfo solverInfo = INSTANCE;
        @Nullable
        private final Integer randomSeed;
        public static final /* enum */ ClOptions Default = new Default("Default", 0);
        private static final /* synthetic */ ClOptions[] $VALUES;

        private ClOptions() {
        }

        @Override
        @NotNull
        public VampireSolverInfo getSolverInfo() {
            return this.solverInfo;
        }

        @Override
        @Nullable
        public Integer getRandomSeed() {
            return this.randomSeed;
        }

        @Override
        @NotNull
        public String getClFullName() {
            return SolverInfoClOptions.DefaultImpls.getClFullName(this);
        }

        @Override
        @NotNull
        public CommonSolverClOptions getCommonSolverClOptions() {
            return SolverInfoClOptions.DefaultImpls.getCommonSolverClOptions(this);
        }

        public static ClOptions[] values() {
            return (ClOptions[])$VALUES.clone();
        }

        public static ClOptions valueOf(String value) {
            return Enum.valueOf(ClOptions.class, value);
        }

        public /* synthetic */ ClOptions(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = clOptionsArray = new ClOptions[]{ClOptions.Default};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/VampireSolverInfo$ClOptions$Default;", "Lsolver/VampireSolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Default
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions = CollectionsKt.emptyList();

            /*
             * WARNING - void declaration
             */
            Default() {
                void var1_1;
                this.clVariantName = "def";
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return true;
            }
        }
    }
}

