/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.AltErgoSolverInfo;
import solver.BitwuzlaSolverInfo;
import solver.CVC4SolverInfo;
import solver.CVC5SolverInfo;
import solver.CommonSolverClOptions;
import solver.SolverConfig;
import solver.SolverInfo;
import solver.VampireSolverInfo;
import solver.YicesSolverInfo;
import solver.Z3SolverInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lsolver/SolverInfoClOptions;", "Ljava/io/Serializable;", "clFullName", "", "getClFullName", "()Ljava/lang/String;", "clOptions", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "commonSolverClOptions", "Lsolver/CommonSolverClOptions;", "getCommonSolverClOptions", "()Lsolver/CommonSolverClOptions;", "randomSeed", "", "getRandomSeed", "()Ljava/lang/Integer;", "solverInfo", "Lsolver/SolverInfo;", "getSolverInfo", "()Lsolver/SolverInfo;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "Companion", "GeneralUtils"})
public interface SolverInfoClOptions
extends Serializable {
    @NotNull
    public static final Companion Companion = solver.SolverInfoClOptions$Companion.$$INSTANCE;

    @NotNull
    public String getClVariantName();

    @NotNull
    public String getClFullName();

    @NotNull
    public List<String> getClOptions();

    @NotNull
    public SolverInfo getSolverInfo();

    @NotNull
    public CommonSolverClOptions getCommonSolverClOptions();

    @Nullable
    public Integer getRandomSeed();

    public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lsolver/SolverInfoClOptions$Companion;", "", "()V", "fromConfigNameString", "", "Lsolver/SolverInfoClOptions;", "solverName", "", "GeneralUtils"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SolverInfoClOptions> fromConfigNameString(@NotNull String solverName) {
            List<SolverInfoClOptions> list2;
            Intrinsics.checkNotNullParameter(solverName, "solverName");
            if (Intrinsics.areEqual(solverName, "z3")) {
                list2 = ArraysKt.toList(Z3SolverInfo.ClOptions.values());
            } else if (Intrinsics.areEqual(solverName, "cvc5")) {
                list2 = ArraysKt.toList(CVC5SolverInfo.ClOptions.values());
            } else if (Intrinsics.areEqual(solverName, "cvc4")) {
                list2 = ArraysKt.toList(CVC4SolverInfo.ClOptions.values());
            } else if (Intrinsics.areEqual(solverName, "yices")) {
                list2 = ArraysKt.toList(YicesSolverInfo.ClOptions.values());
            } else {
                String[] stringArray = new String[]{"vprover", "vampire"};
                if (CollectionsKt.listOf(stringArray).contains(solverName)) {
                    list2 = ArraysKt.toList(VampireSolverInfo.ClOptions.values());
                } else {
                    stringArray = new String[]{"alt-ergo", "altergo"};
                    if (CollectionsKt.listOf(stringArray).contains(solverName)) {
                        list2 = ArraysKt.toList(AltErgoSolverInfo.ClOptions.values());
                    } else if (Intrinsics.areEqual(solverName, "bitwuzla")) {
                        list2 = ArraysKt.toList(BitwuzlaSolverInfo.ClOptions.values());
                    } else {
                        void $this$mapNotNullTo$iv$iv;
                        stringArray = new Serializable[][]{Z3SolverInfo.ClOptions.values(), CVC5SolverInfo.ClOptions.values(), CVC4SolverInfo.ClOptions.values(), YicesSolverInfo.ClOptions.values(), VampireSolverInfo.ClOptions.values(), AltErgoSolverInfo.ClOptions.values(), BitwuzlaSolverInfo.ClOptions.values()};
                        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])stringArray);
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            Serializable serializable;
                            block17: {
                                Object element$iv$iv$iv;
                                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                                boolean bl = false;
                                Serializable[] enumList = (Serializable[])element$iv$iv;
                                boolean bl2 = false;
                                for (Serializable serializable2 : enumList) {
                                    Serializable it = serializable2;
                                    boolean bl3 = false;
                                    if (!Intrinsics.areEqual(((SolverInfoClOptions)it).getClFullName(), solverName)) continue;
                                    serializable = serializable2;
                                    break block17;
                                }
                                serializable = null;
                            }
                            if (serializable == null) continue;
                            Serializable it$iv$iv = serializable;
                            boolean bl = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        list2 = (List)destination$iv$iv;
                    }
                }
            }
            List<SolverInfoClOptions> solverInfoClOptions = list2;
            if (!(!((Collection)solverInfoClOptions).isEmpty())) {
                boolean bl = false;
                String string2 = "Unrecognized solver configuration name: " + solverName;
                throw new IllegalArgumentException(string2.toString());
            }
            return solverInfoClOptions;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String getClFullName(@NotNull SolverInfoClOptions this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            String string2 = this_.getSolverInfo().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string2 + "_" + this_.getClVariantName();
        }

        @NotNull
        public static CommonSolverClOptions getCommonSolverClOptions(@NotNull SolverInfoClOptions this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return new CommonSolverClOptions(null, 1, null);
        }

        @Nullable
        public static Integer getRandomSeed(@NotNull SolverInfoClOptions this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getCommonSolverClOptions().getRandomSeed();
        }
    }
}

