/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.CommonSolverClOptions;
import solver.SolverConfig;
import solver.SolverInfo;
import solver.SolverInfoClOptions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J+\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lsolver/CVC5SolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_CVC_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "randomSeed", "", "(Ljava/lang/String;Ljava/time/Duration;ZLjava/lang/Integer;)Ljava/util/List;", "getBitVectorConfigs", "Lsolver/SolverConfig;", "memlimitBytes", "", "(Ljava/time/Duration;Ljava/lang/Long;Z)Ljava/util/List;", "getNonLinearConfigs", "getProcessTimeoutString", "getQuantifierConfigs", "getQueryRandomSeedString", "getQueryTimeoutString", "supportsLogicFeatures", "features", "Lsolver/SolverConfig$LogicFeatures;", "ClOptions", "GeneralUtils"})
public final class CVC5SolverInfo
extends SolverInfo {
    @NotNull
    public static final CVC5SolverInfo INSTANCE = new CVC5SolverInfo();
    @NotNull
    private static final String DEFAULT_CVC_COMMAND = "cvc5";

    private CVC5SolverInfo() {
        super("CVC5");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf("--tlimit=" + timeout.toMillis());
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf("--tlimit-per=" + timeout.toMillis());
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> getQueryRandomSeedString(int randomSeed) {
        return CollectionsKt.listOf("--seed=" + randomSeed);
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode, @Nullable Integer randomSeed) {
        String[] stringArray = new String[3];
        String string2 = customSolverExecutable;
        if (string2 == null) {
            string2 = DEFAULT_CVC_COMMAND;
        }
        stringArray[0] = string2;
        stringArray[1] = "--lang";
        stringArray[2] = "smt2";
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)(incrementalMode ? CollectionsKt.listOf("--incremental") : CollectionsKt.listOf("--no-incremental"))), (Iterable)(timeout != null ? this.getQueryTimeoutString(timeout) : CollectionsKt.emptyList())), (Iterable)(randomSeed != null ? this.getQueryRandomSeedString(randomSeed) : CollectionsKt.emptyList())), (Iterable)CollectionsKt.listOf("--dag-thresh=0"));
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_CVC_COMMAND;
    }

    @NotNull
    public final List<SolverConfig> getQuantifierConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(SolverInfo.Companion.getConfig(ClOptions.Quantifiers, timeout, memlimitBytes, incrementalMode));
    }

    @NotNull
    public final List<SolverConfig> getNonLinearConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(SolverInfo.Companion.getConfig(ClOptions.NonLinear, timeout, memlimitBytes, incrementalMode));
    }

    @NotNull
    public final List<SolverConfig> getBitVectorConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        boolean $i$f$unused = false;
        $i$f$unused = false;
        $i$f$unused = incrementalMode;
        boolean $i$f$unused2 = false;
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lsolver/CVC5SolverInfo$ClOptions;", "", "Lsolver/SolverInfoClOptions;", "(Ljava/lang/String;I)V", "randomSeed", "", "getRandomSeed", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "solverInfo", "Lsolver/CVC5SolverInfo;", "getSolverInfo", "()Lsolver/CVC5SolverInfo;", "Default", "NonLinear", "LinearOnly", "Quantifiers", "GeneralUtils"})
    public static final abstract class ClOptions
    extends Enum<ClOptions>
    implements SolverInfoClOptions {
        @NotNull
        private final CVC5SolverInfo solverInfo = INSTANCE;
        @Nullable
        private final Integer randomSeed;
        public static final /* enum */ ClOptions Default = new Default("Default", 0);
        public static final /* enum */ ClOptions NonLinear = new NonLinear("NonLinear", 1);
        public static final /* enum */ ClOptions LinearOnly = new LinearOnly("LinearOnly", 2);
        public static final /* enum */ ClOptions Quantifiers = new Quantifiers("Quantifiers", 3);
        private static final /* synthetic */ ClOptions[] $VALUES;

        private ClOptions() {
        }

        @Override
        @NotNull
        public CVC5SolverInfo getSolverInfo() {
            return this.solverInfo;
        }

        @Override
        @Nullable
        public Integer getRandomSeed() {
            return this.randomSeed;
        }

        @Override
        @NotNull
        public String getClFullName() {
            return SolverInfoClOptions.DefaultImpls.getClFullName(this);
        }

        @Override
        @NotNull
        public CommonSolverClOptions getCommonSolverClOptions() {
            return SolverInfoClOptions.DefaultImpls.getCommonSolverClOptions(this);
        }

        public static ClOptions[] values() {
            return (ClOptions[])$VALUES.clone();
        }

        public static ClOptions valueOf(String value) {
            return Enum.valueOf(ClOptions.class, value);
        }

        public /* synthetic */ ClOptions(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = clOptionsArray = new ClOptions[]{ClOptions.Default, ClOptions.NonLinear, ClOptions.LinearOnly, ClOptions.Quantifiers};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/CVC5SolverInfo$ClOptions$Default;", "Lsolver/CVC5SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Default
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions = CollectionsKt.emptyList();

            /*
             * WARNING - void declaration
             */
            Default() {
                void var1_1;
                this.clVariantName = "def";
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return true;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/CVC5SolverInfo$ClOptions$NonLinear;", "Lsolver/CVC5SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class NonLinear
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions;

            /*
             * WARNING - void declaration
             */
            NonLinear() {
                void var1_1;
                this.clVariantName = "nonlin";
                String[] stringArray = new String[]{"--nl-ext-tplanes", "--decision=justification"};
                this.clOptions = CollectionsKt.listOf(stringArray);
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return logicFeatures.getArithmeticOperations() == SolverConfig.ArithmeticOperations.NonLinear;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/CVC5SolverInfo$ClOptions$LinearOnly;", "Lsolver/CVC5SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class LinearOnly
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions = CollectionsKt.listOf("--decision=justification");

            /*
             * WARNING - void declaration
             */
            LinearOnly() {
                void var1_1;
                this.clVariantName = "lin";
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return logicFeatures.getArithmeticOperations() == SolverConfig.ArithmeticOperations.LinearOnly;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/CVC5SolverInfo$ClOptions$Quantifiers;", "Lsolver/CVC5SolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Quantifiers
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions = CollectionsKt.listOf("--full-saturate-quant");

            /*
             * WARNING - void declaration
             */
            Quantifiers() {
                void var1_1;
                this.clVariantName = "q";
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return false;
            }
        }
    }
}

