/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import log.CvtLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.CommonSolverClOptions;
import solver.SolverConfig;
import solver.SolverInfo;
import solver.SolverInfoClOptions;
import utils.RuntimeEnvInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lsolver/AltErgoSolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_ALT_ERGO_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "logger", "Llog/CvtLogger;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "randomSeed", "", "(Ljava/lang/String;Ljava/time/Duration;ZLjava/lang/Integer;)Ljava/util/List;", "getProcessTimeoutString", "getQueryTimeoutString", "supportsLogicFeatures", "features", "Lsolver/SolverConfig$LogicFeatures;", "ClOptions", "GeneralUtils"})
public final class AltErgoSolverInfo
extends SolverInfo {
    @NotNull
    public static final AltErgoSolverInfo INSTANCE = new AltErgoSolverInfo();
    @NotNull
    private static final CvtLogger logger;
    @NotNull
    private static final String DEFAULT_ALT_ERGO_COMMAND = "alt-ergo";

    private AltErgoSolverInfo() {
        super("Alt-Ergo");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf("--timelimit=" + timeout.toSeconds());
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf("--timelimit=" + timeout.toSeconds());
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode, @Nullable Integer randomSeed) {
        if (!(!incrementalMode)) {
            boolean bl = false;
            throw new UnsupportedOperationException("support of incremental mode by Alt-Ergo (in SMT-mode) is unclear (might investigate)");
        }
        if (randomSeed != null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(randomSeed){
                final /* synthetic */ Integer $randomSeed;
                {
                    this.$randomSeed = $randomSeed;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "AltErgo does not support changing the random seed (tried to set it to " + this.$randomSeed + ")";
                }
            });
        }
        Collection collection = RuntimeEnvInfo.INSTANCE.getTimeoutCommandIfAvailable(timeout);
        String string2 = customSolverExecutable;
        if (string2 == null) {
            string2 = DEFAULT_ALT_ERGO_COMMAND;
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)CollectionsKt.listOf(string2)), (Iterable)CollectionsKt.listOf("--input=smtlib2")), (Iterable)(timeout != null ? this.getQueryTimeoutString(timeout) : CollectionsKt.emptyList()));
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_ALT_ERGO_COMMAND;
    }

    static {
        String[] stringArray = new String[]{"generalutils", "AltErgoSolverInfo"};
        logger = new CvtLogger(stringArray, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lsolver/AltErgoSolverInfo$ClOptions;", "", "Lsolver/SolverInfoClOptions;", "(Ljava/lang/String;I)V", "randomSeed", "", "getRandomSeed", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "solverInfo", "Lsolver/AltErgoSolverInfo;", "getSolverInfo", "()Lsolver/AltErgoSolverInfo;", "Default", "GeneralUtils"})
    public static final abstract class ClOptions
    extends Enum<ClOptions>
    implements SolverInfoClOptions {
        @NotNull
        private final AltErgoSolverInfo solverInfo = INSTANCE;
        @Nullable
        private final Integer randomSeed;
        public static final /* enum */ ClOptions Default = new Default("Default", 0);
        private static final /* synthetic */ ClOptions[] $VALUES;

        private ClOptions() {
        }

        @Override
        @NotNull
        public AltErgoSolverInfo getSolverInfo() {
            return this.solverInfo;
        }

        @Override
        @Nullable
        public Integer getRandomSeed() {
            return this.randomSeed;
        }

        @Override
        @NotNull
        public String getClFullName() {
            return SolverInfoClOptions.DefaultImpls.getClFullName(this);
        }

        @Override
        @NotNull
        public CommonSolverClOptions getCommonSolverClOptions() {
            return SolverInfoClOptions.DefaultImpls.getCommonSolverClOptions(this);
        }

        public static ClOptions[] values() {
            return (ClOptions[])$VALUES.clone();
        }

        public static ClOptions valueOf(String value) {
            return Enum.valueOf(ClOptions.class, value);
        }

        public /* synthetic */ ClOptions(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = clOptionsArray = new ClOptions[]{ClOptions.Default};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lsolver/AltErgoSolverInfo$ClOptions$Default;", "Lsolver/AltErgoSolverInfo$ClOptions;", "clOptions", "", "", "getClOptions", "()Ljava/util/List;", "clVariantName", "getClVariantName", "()Ljava/lang/String;", "qualifiesFor", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
        static final class Default
        extends ClOptions {
            @NotNull
            private final String clVariantName;
            @NotNull
            private final List<String> clOptions = CollectionsKt.emptyList();

            /*
             * WARNING - void declaration
             */
            Default() {
                void var1_1;
                this.clVariantName = "def";
            }

            @Override
            @NotNull
            public String getClVariantName() {
                return this.clVariantName;
            }

            @Override
            @NotNull
            public List<String> getClOptions() {
                return this.clOptions;
            }

            @Override
            public boolean qualifiesFor(@NotNull SolverConfig.LogicFeatures logicFeatures) {
                Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
                return true;
            }
        }
    }
}

