/*
 * Decompiled with CFR 0.152.
 */
package scene;

import allocator.Allocator;
import bridge.ContractInstanceInSDC;
import caching.WithMemento;
import disassembler.DisassembledEVMBytecode;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scene.ContractWithStateLinkInfo;
import scene.IContractWithSource;
import scene.IMutableStorageInfo;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import tac.ICoreTACProgram;
import tac.IStorageInfo;
import tac.TACStorageSlot;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00015J\b\u0010\u0017\u001a\u00020\u0000H&J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH&J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020\u0004H&J\u0012\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\"H&J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190$H\u0016J\u001c\u0010%\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020'\u0018\u00010&j\u0004\u0018\u0001`(H&J\b\u0010)\u001a\u00020\u0019H\u0016J*\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002000/H&J*\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020+0/H\u0016J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u0002H\u0016J\b\u00104\u001a\u00020\u0002H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lscene/IContractClass;", "Lcaching/WithMemento;", "Lscene/IContractClass$ContractMemento;", "address", "Ljava/math/BigInteger;", "getAddress", "()Ljava/math/BigInteger;", "bytecode", "Ldisassembler/DisassembledEVMBytecode;", "getBytecode", "()Ldisassembler/DisassembledEVMBytecode;", "constructorBytecode", "getConstructorBytecode", "constructorCodeName", "", "getConstructorCodeName", "()Ljava/lang/String;", "name", "getName", "storage", "Ltac/IStorageInfo;", "getStorage", "()Ltac/IStorageInfo;", "fork", "getConstructor", "Lscene/ITACMethod;", "getContractStateLinks", "Lscene/ContractWithStateLinkInfo;", "getDeclaredMethods", "", "getMethodBySigHash", "sig", "getMethodByUniqueAttribute", "attr", "Lscene/MethodAttribute$Unique;", "getMethods", "", "getStorageLayout", "", "Ltac/TACStorageSlot;", "Ltac/TACStorageLayout;", "getWholeContract", "mapMethods", "", "scene", "Lscene/IScene;", "p", "Lkotlin/Function2;", "Ltac/ICoreTACProgram;", "mapMethodsInPlace", "restore", "m", "saveState", "ContractMemento", "Shared"})
public interface IContractClass
extends WithMemento<ContractMemento> {
    @NotNull
    public ITACMethod getWholeContract();

    @Nullable
    public ITACMethod getConstructor();

    @Nullable
    public ITACMethod getMethodBySigHash(@NotNull BigInteger var1);

    @Nullable
    public ITACMethod getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique var1);

    @NotNull
    public IStorageInfo getStorage();

    @Nullable
    public Map<String, TACStorageSlot> getStorageLayout();

    @NotNull
    public List<ITACMethod> getMethods();

    @NotNull
    public Collection<ITACMethod> getDeclaredMethods();

    public void mapMethodsInPlace(@NotNull IScene var1, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> var2);

    public void mapMethods(@NotNull IScene var1, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> var2);

    @NotNull
    public IContractClass fork();

    @NotNull
    public BigInteger getAddress();

    @NotNull
    public String getName();

    @Nullable
    public DisassembledEVMBytecode getBytecode();

    @Nullable
    public DisassembledEVMBytecode getConstructorBytecode();

    @NotNull
    public String getConstructorCodeName();

    @Override
    @NotNull
    public ContractMemento saveState();

    @Override
    public void restore(@NotNull ContractMemento var1);

    @Nullable
    public ContractWithStateLinkInfo getContractStateLinks();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B3\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lscene/IContractClass$ContractMemento;", "Ljava/io/Serializable;", "methods", "", "Ljava/math/BigInteger;", "Ltac/ICoreTACProgram;", "constructorCode", "Lscene/ITACMethod;", "storageInfo", "Ltac/IStorageInfo;", "allocState", "Lallocator/Allocator$Memento;", "(Ljava/util/Map;Lscene/ITACMethod;Ltac/IStorageInfo;Lallocator/Allocator$Memento;)V", "getAllocState", "()Lallocator/Allocator$Memento;", "getConstructorCode", "()Lscene/ITACMethod;", "getMethods", "()Ljava/util/Map;", "getStorageInfo", "()Ltac/IStorageInfo;", "Shared"})
    public static final class ContractMemento
    implements Serializable {
        @NotNull
        private final Map<BigInteger, ICoreTACProgram> methods;
        @Nullable
        private final ITACMethod constructorCode;
        @NotNull
        private final IStorageInfo storageInfo;
        @NotNull
        private final Allocator.Memento allocState;

        public ContractMemento(@NotNull Map<BigInteger, ? extends ICoreTACProgram> methods, @Nullable ITACMethod constructorCode, @NotNull IStorageInfo storageInfo, @NotNull Allocator.Memento allocState) {
            Intrinsics.checkNotNullParameter(methods, "methods");
            Intrinsics.checkNotNullParameter(storageInfo, "storageInfo");
            Intrinsics.checkNotNullParameter(allocState, "allocState");
            this.methods = methods;
            this.constructorCode = constructorCode;
            this.storageInfo = storageInfo;
            this.allocState = allocState;
        }

        @NotNull
        public final Map<BigInteger, ICoreTACProgram> getMethods() {
            return this.methods;
        }

        @Nullable
        public final ITACMethod getConstructorCode() {
            return this.constructorCode;
        }

        @NotNull
        public final IStorageInfo getStorageInfo() {
            return this.storageInfo;
        }

        @NotNull
        public final Allocator.Memento getAllocState() {
            return this.allocState;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ITACMethod getWholeContract(@NotNull IContractClass this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            ITACMethod iTACMethod = this_.getMethodByUniqueAttribute(MethodAttribute.Unique.Whole.INSTANCE);
            if (iTACMethod == null) {
                throw new IllegalStateException("Can't ask for whole contract before loading".toString());
            }
            return iTACMethod;
        }

        @Nullable
        public static ITACMethod getConstructor(@NotNull IContractClass this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getMethodByUniqueAttribute(MethodAttribute.Unique.Constructor.INSTANCE);
        }

        @NotNull
        public static List<ITACMethod> getMethods(@NotNull IContractClass this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return CollectionsKt.plus(this_.getDeclaredMethods(), this_.getWholeContract());
        }

        public static void mapMethodsInPlace(@NotNull IContractClass this_, @NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(scene, "scene");
            Intrinsics.checkNotNullParameter(p, "p");
            Iterable $this$forEach$iv = this_.getDeclaredMethods();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ITACMethod it = (ITACMethod)element$iv;
                boolean bl = false;
                p.invoke(scene, it);
            }
        }

        @NotNull
        public static String getConstructorCodeName(@NotNull IContractClass this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return "constructor_" + this_.getName();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ContractMemento saveState(@NotNull IContractClass this_) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(this_, "this");
            Iterable $this$map$iv = this_.getMethods();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ITACMethod iTACMethod = (ITACMethod)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getSigHash().getN(), it.getCode()));
            }
            Allocator.Memento memento = Allocator.INSTANCE.saveState();
            IStorageInfo iStorageInfo = this_.getStorage();
            ITACMethod iTACMethod = this_.getConstructor();
            Map map2 = MapsKt.toMap((List)destination$iv$iv);
            return new ContractMemento(map2, iTACMethod, iStorageInfo, memento);
        }

        public static void restore(@NotNull IContractClass this_, @NotNull ContractMemento m) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(m, "m");
            for (ITACMethod meth : this_.getMethods()) {
                ICoreTACProgram iCoreTACProgram = m.getMethods().get(meth.getSigHash().getN());
                if (iCoreTACProgram == null) {
                    throw new IllegalStateException("Broken cache".toString());
                }
                meth.setCode(iCoreTACProgram);
            }
            ITACMethod iTACMethod = this_.getConstructor();
            if (iTACMethod != null) {
                ITACMethod iTACMethod2 = m.getConstructorCode();
                Intrinsics.checkNotNull(iTACMethod2);
                iTACMethod.setCode(iTACMethod2.getCode());
            }
            if (this_ instanceof IMutableStorageInfo) {
                ((IMutableStorageInfo)((Object)this_)).setStorageInfo(m.getStorageInfo());
            } else if (!Intrinsics.areEqual(this_.getStorage(), m.getStorageInfo())) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            Allocator.INSTANCE.restore(m.getAllocState());
        }

        @Nullable
        public static ContractWithStateLinkInfo getContractStateLinks(@NotNull IContractClass this_) {
            ContractWithStateLinkInfo contractWithStateLinkInfo;
            Intrinsics.checkNotNullParameter(this_, "this");
            IContractWithSource iContractWithSource = this_ instanceof IContractWithSource ? (IContractWithSource)((Object)this_) : null;
            if (iContractWithSource == null) {
                contractWithStateLinkInfo = null;
            } else {
                ContractInstanceInSDC contractInstanceInSDC = iContractWithSource.getSrc();
                if (contractInstanceInSDC == null) {
                    contractWithStateLinkInfo = null;
                } else {
                    Map<BigInteger, BigInteger> map2 = contractInstanceInSDC.getState();
                    if (map2 == null) {
                        contractWithStateLinkInfo = null;
                    } else {
                        Map<BigInteger, BigInteger> it = map2;
                        boolean bl = false;
                        contractWithStateLinkInfo = new ContractWithStateLinkInfo(this_, it);
                    }
                }
            }
            return contractWithStateLinkInfo;
        }
    }
}

