/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BooleanUtils {
    public static Boolean negate(Boolean bool2) {
        if (bool2 == null) {
            return null;
        }
        return bool2 != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bool2) {
        return Boolean.TRUE.equals(bool2);
    }

    public static boolean isNotTrue(Boolean bool2) {
        return !BooleanUtils.isTrue(bool2);
    }

    public static boolean isFalse(Boolean bool2) {
        return Boolean.FALSE.equals(bool2);
    }

    public static boolean isNotFalse(Boolean bool2) {
        return !BooleanUtils.isFalse(bool2);
    }

    public static boolean toBoolean(Boolean bool2) {
        return bool2 != null && bool2 != false;
    }

    public static boolean toBooleanDefaultIfNull(Boolean bool2, boolean valueIfNull) {
        if (bool2 == null) {
            return valueIfNull;
        }
        return bool2;
    }

    public static boolean toBoolean(int value) {
        return value != 0;
    }

    public static Boolean toBooleanObject(int value) {
        return value == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Boolean toBooleanObject(Integer value) {
        if (value == null) {
            return null;
        }
        return value == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean toBoolean(int value, int trueValue, int falseValue) {
        if (value == trueValue) {
            return true;
        }
        if (value == falseValue) {
            return false;
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static boolean toBoolean(Integer value, Integer trueValue, Integer falseValue) {
        if (value == null) {
            if (trueValue == null) {
                return true;
            }
            if (falseValue == null) {
                return false;
            }
        } else {
            if (value.equals(trueValue)) {
                return true;
            }
            if (value.equals(falseValue)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static Boolean toBooleanObject(int value, int trueValue, int falseValue, int nullValue) {
        if (value == trueValue) {
            return Boolean.TRUE;
        }
        if (value == falseValue) {
            return Boolean.FALSE;
        }
        if (value == nullValue) {
            return null;
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static Boolean toBooleanObject(Integer value, Integer trueValue, Integer falseValue, Integer nullValue) {
        if (value == null) {
            if (trueValue == null) {
                return Boolean.TRUE;
            }
            if (falseValue == null) {
                return Boolean.FALSE;
            }
            if (nullValue == null) {
                return null;
            }
        } else {
            if (value.equals(trueValue)) {
                return Boolean.TRUE;
            }
            if (value.equals(falseValue)) {
                return Boolean.FALSE;
            }
            if (value.equals(nullValue)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static int toInteger(boolean bool2) {
        return bool2 ? 1 : 0;
    }

    public static Integer toIntegerObject(boolean bool2) {
        return bool2 ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO;
    }

    public static Integer toIntegerObject(Boolean bool2) {
        if (bool2 == null) {
            return null;
        }
        return bool2 != false ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO;
    }

    public static int toInteger(boolean bool2, int trueValue, int falseValue) {
        return bool2 ? trueValue : falseValue;
    }

    public static int toInteger(Boolean bool2, int trueValue, int falseValue, int nullValue) {
        if (bool2 == null) {
            return nullValue;
        }
        return bool2 != false ? trueValue : falseValue;
    }

    public static Integer toIntegerObject(boolean bool2, Integer trueValue, Integer falseValue) {
        return bool2 ? trueValue : falseValue;
    }

    public static Integer toIntegerObject(Boolean bool2, Integer trueValue, Integer falseValue, Integer nullValue) {
        if (bool2 == null) {
            return nullValue;
        }
        return bool2 != false ? trueValue : falseValue;
    }

    public static Boolean toBooleanObject(String str2) {
        if (str2 == "true") {
            return Boolean.TRUE;
        }
        if (str2 == null) {
            return null;
        }
        switch (str2.length()) {
            case 1: {
                char ch0 = str2.charAt(0);
                if (ch0 == 'y' || ch0 == 'Y' || ch0 == 't' || ch0 == 'T' || ch0 == '1') {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' && ch0 != 'f' && ch0 != 'F' && ch0 != '0') break;
                return Boolean.FALSE;
            }
            case 2: {
                char ch0 = str2.charAt(0);
                char ch1 = str2.charAt(1);
                if (!(ch0 != 'o' && ch0 != 'O' || ch1 != 'n' && ch1 != 'N')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' || ch1 != 'o' && ch1 != 'O') break;
                return Boolean.FALSE;
            }
            case 3: {
                char ch0 = str2.charAt(0);
                char ch1 = str2.charAt(1);
                char ch2 = str2.charAt(2);
                if (!(ch0 != 'y' && ch0 != 'Y' || ch1 != 'e' && ch1 != 'E' || ch2 != 's' && ch2 != 'S')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'o' && ch0 != 'O' || ch1 != 'f' && ch1 != 'F' || ch2 != 'f' && ch2 != 'F') break;
                return Boolean.FALSE;
            }
            case 4: {
                char ch0 = str2.charAt(0);
                char ch1 = str2.charAt(1);
                char ch2 = str2.charAt(2);
                char ch3 = str2.charAt(3);
                if (ch0 != 't' && ch0 != 'T' || ch1 != 'r' && ch1 != 'R' || ch2 != 'u' && ch2 != 'U' || ch3 != 'e' && ch3 != 'E') break;
                return Boolean.TRUE;
            }
            case 5: {
                char ch0 = str2.charAt(0);
                char ch1 = str2.charAt(1);
                char ch2 = str2.charAt(2);
                char ch3 = str2.charAt(3);
                char ch4 = str2.charAt(4);
                if (ch0 != 'f' && ch0 != 'F' || ch1 != 'a' && ch1 != 'A' || ch2 != 'l' && ch2 != 'L' || ch3 != 's' && ch3 != 'S' || ch4 != 'e' && ch4 != 'E') break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static Boolean toBooleanObject(String str2, String trueString, String falseString, String nullString) {
        if (str2 == null) {
            if (trueString == null) {
                return Boolean.TRUE;
            }
            if (falseString == null) {
                return Boolean.FALSE;
            }
            if (nullString == null) {
                return null;
            }
        } else {
            if (str2.equals(trueString)) {
                return Boolean.TRUE;
            }
            if (str2.equals(falseString)) {
                return Boolean.FALSE;
            }
            if (str2.equals(nullString)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The String did not match any specified value");
    }

    public static boolean toBoolean(String str2) {
        return BooleanUtils.toBooleanObject(str2) == Boolean.TRUE;
    }

    public static boolean toBoolean(String str2, String trueString, String falseString) {
        if (str2 == trueString) {
            return true;
        }
        if (str2 == falseString) {
            return false;
        }
        if (str2 != null) {
            if (str2.equals(trueString)) {
                return true;
            }
            if (str2.equals(falseString)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The String did not match either specified value");
    }

    public static String toStringTrueFalse(Boolean bool2) {
        return BooleanUtils.toString(bool2, "true", "false", null);
    }

    public static String toStringOnOff(Boolean bool2) {
        return BooleanUtils.toString(bool2, "on", "off", null);
    }

    public static String toStringYesNo(Boolean bool2) {
        return BooleanUtils.toString(bool2, "yes", "no", null);
    }

    public static String toString(Boolean bool2, String trueString, String falseString, String nullString) {
        if (bool2 == null) {
            return nullString;
        }
        return bool2 != false ? trueString : falseString;
    }

    public static String toStringTrueFalse(boolean bool2) {
        return BooleanUtils.toString(bool2, "true", "false");
    }

    public static String toStringOnOff(boolean bool2) {
        return BooleanUtils.toString(bool2, "on", "off");
    }

    public static String toStringYesNo(boolean bool2) {
        return BooleanUtils.toString(bool2, "yes", "no");
    }

    public static String toString(boolean bool2, String trueString, String falseString) {
        return bool2 ? trueString : falseString;
    }

    public static boolean and(boolean ... array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        for (boolean element : array) {
            if (element) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(Boolean ... array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        try {
            boolean[] primitive = ArrayUtils.toPrimitive(array);
            return BooleanUtils.and(primitive) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }

    public static boolean or(boolean ... array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        for (boolean element : array) {
            if (!element) continue;
            return true;
        }
        return false;
    }

    public static Boolean or(Boolean ... array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        try {
            boolean[] primitive = ArrayUtils.toPrimitive(array);
            return BooleanUtils.or(primitive) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }

    public static boolean xor(boolean ... array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        boolean result2 = false;
        for (boolean element : array) {
            result2 ^= element;
        }
        return result2;
    }

    public static Boolean xor(Boolean ... array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        try {
            boolean[] primitive = ArrayUtils.toPrimitive(array);
            return BooleanUtils.xor(primitive) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }

    public static int compare(boolean x, boolean y) {
        if (x == y) {
            return 0;
        }
        return x ? 1 : -1;
    }
}

