/*
 * Decompiled with CFR 0.152.
 */
package evm;

import java.io.Serializable;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Levm/SighashInt;", "Ljava/io/Serializable;", "n", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "getN", "()Ljava/math/BigInteger;", "equals", "", "other", "", "getOrNull", "hashCode", "", "invoke", "toString", "", "Companion", "Shared"})
public final class SighashInt
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger n;
    @NotNull
    private static final SighashInt Error;

    public SighashInt(@NotNull BigInteger n) {
        Intrinsics.checkNotNullParameter(n, "n");
        this.n = n;
    }

    @NotNull
    public final BigInteger getN() {
        return this.n;
    }

    @NotNull
    public final BigInteger invoke() {
        if (!Companion.isValid(this.n)) {
            boolean bl = false;
            String string2 = Companion.badSigHash(this.getN());
            throw new IllegalStateException(string2.toString());
        }
        return this.n;
    }

    @Nullable
    public final BigInteger getOrNull() {
        return Companion.isValid(this.n) ? this.n : (BigInteger)null;
    }

    @NotNull
    public String toString() {
        return "SigHash(" + this.n.toString(16) + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SighashInt)) {
            return false;
        }
        return Intrinsics.areEqual(this.n, ((SighashInt)other).n);
    }

    public int hashCode() {
        return this.n.hashCode();
    }

    static {
        BigInteger bigInteger = BigInteger.ZERO;
        Intrinsics.checkNotNullExpressionValue(bigInteger, "ZERO");
        Error = new SighashInt(bigInteger);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Levm/SighashInt$Companion;", "", "()V", "Error", "Levm/SighashInt;", "getError", "()Levm/SighashInt;", "badSigHash", "", "n", "Ljava/math/BigInteger;", "isValid", "", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SighashInt getError() {
            return Error;
        }

        public final boolean isValid(@NotNull BigInteger n) {
            Intrinsics.checkNotNullParameter(n, "n");
            return n.compareTo(BigInteger.ZERO) >= 0 && n.compareTo(BigInteger.TWO.pow(32)) < 0;
        }

        @NotNull
        public final String badSigHash(@NotNull BigInteger n) {
            Intrinsics.checkNotNullParameter(n, "n");
            return "Sighash is a 32-bit number, got " + n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

