/*
 * Decompiled with CFR 0.152.
 */
package eventreports;

import eventreports.EventBase;
import eventreports.EventStreamBase;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import log.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Leventreports/FileEventStream;", "Leventreports/EventStreamBase;", "Ljava/lang/AutoCloseable;", "outFileName", "", "formatEvent", "Lkotlin/Function1;", "Leventreports/EventBase;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "channel", "Ljava/io/BufferedWriter;", "getFormatEvent", "()Lkotlin/jvm/functions/Function1;", "close", "", "sendEvents", "evts", "", "Shared"})
public class FileEventStream
extends EventStreamBase
implements AutoCloseable {
    @NotNull
    private final Function1<EventBase, String> formatEvent;
    @NotNull
    private final BufferedWriter channel;

    public FileEventStream(@NotNull String outFileName, @NotNull Function1<? super EventBase, String> formatEvent) {
        Intrinsics.checkNotNullParameter(outFileName, "outFileName");
        Intrinsics.checkNotNullParameter(formatEvent, "formatEvent");
        this.formatEvent = formatEvent;
        OutputStream outputStream = new FileOutputStream(new File(outFileName));
        Charset charset = Charsets.UTF_8;
        Closeable closeable = outputStream;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        int n = 8192;
        this.channel = closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n);
    }

    @NotNull
    public final Function1<EventBase, String> getFormatEvent() {
        return this.formatEvent;
    }

    @Override
    protected synchronized void sendEvents(@NotNull List<? extends EventBase> evts) {
        Intrinsics.checkNotNullParameter(evts, "evts");
        Iterable $this$forEach$iv = evts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventBase it = (EventBase)element$iv;
            boolean bl = false;
            try {
                String output = this.getFormatEvent().invoke(it);
                this.channel.write(output + System.lineSeparator());
                this.channel.flush();
            }
            catch (Exception e) {
                Logger.Companion.alwaysError("FileEventStream encountered exception " + e.getMessage() + " ", e);
            }
        }
    }

    @Override
    public void close() {
        this.channel.flush();
        this.channel.close();
    }
}

