/*
 * Decompiled with CFR 0.152.
 */
package eventreports;

import eventreports.EventStreamBase;
import eventreports.EventTypeID;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003BQ\u0012$\u0010\u0004\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u00060\u0005\u0012$\u0010\t\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\bJ<\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\r2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\rH\u0002J>\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00180\u0017H\u0002J>\u0010\u0019\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00180\u0017H\u0002R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Leventreports/EventStreamMapper;", "Topic", "", "", "eventsToTopics", "", "Lkotlin/Pair;", "", "Leventreports/EventTypeID;", "topicsToStreams", "Leventreports/EventStreamBase;", "(Ljava/util/List;Ljava/util/List;)V", "eventTypeToStreams", "", "getStreams", "eventType", "mapEventsToStreams", "", "eventTypeToTopics", "topicToStreams", "mapEventsToTopics", "eventTypes", "topics", "", "", "mapTopicsToStreams", "eventStreams", "Shared"})
public final class EventStreamMapper<Topic extends Enum<Topic>> {
    @NotNull
    private Map<EventTypeID, ? extends Set<? extends EventStreamBase>> eventTypeToStreams;

    public EventStreamMapper(@NotNull List<? extends Pair<? extends Set<? extends EventTypeID>, ? extends Set<? extends Topic>>> eventsToTopics, @NotNull List<? extends Pair<? extends Set<? extends Topic>, ? extends Set<? extends EventStreamBase>>> topicsToStreams) {
        Pair it;
        Intrinsics.checkNotNullParameter(eventsToTopics, "eventsToTopics");
        Intrinsics.checkNotNullParameter(topicsToStreams, "topicsToStreams");
        this.eventTypeToStreams = new LinkedHashMap();
        Map eventTypeToTopics = new LinkedHashMap();
        Map topicToStreams = new LinkedHashMap();
        Iterable $this$forEach$iv = eventsToTopics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            this.mapEventsToTopics((Set)it.getFirst(), (Set)it.getSecond(), eventTypeToTopics);
        }
        $this$forEach$iv = topicsToStreams;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            this.mapTopicsToStreams((Set)it.getFirst(), (Set)it.getSecond(), topicToStreams);
        }
        this.mapEventsToStreams(eventTypeToTopics, topicToStreams);
    }

    private final void mapEventsToTopics(Set<? extends EventTypeID> eventTypes, Set<? extends Topic> topics, Map<EventTypeID, Set<Topic>> eventTypeToTopics) {
        for (EventTypeID eventTypeID : eventTypes) {
            Unit unit;
            Unit unit2;
            Set<Topic> set = eventTypeToTopics.get((Object)eventTypeID);
            if (set == null) {
                unit2 = null;
            } else {
                CollectionsKt.addAll((Collection)set, (Iterable)topics);
                unit2 = Unit.INSTANCE;
            }
            if ((unit = unit2) != null) continue;
            eventTypeToTopics.putIfAbsent(eventTypeID, CollectionsKt.toMutableSet((Iterable)topics));
        }
    }

    private final void mapTopicsToStreams(Set<? extends Topic> topics, Set<? extends EventStreamBase> eventStreams, Map<Topic, Set<EventStreamBase>> topicToStreams) {
        for (Enum topic : topics) {
            Unit unit;
            Unit unit2;
            Set<EventStreamBase> set = topicToStreams.get(topic);
            if (set == null) {
                unit2 = null;
            } else {
                CollectionsKt.addAll((Collection)set, (Iterable)eventStreams);
                unit2 = Unit.INSTANCE;
            }
            if ((unit = unit2) != null) continue;
            topicToStreams.putIfAbsent(topic, CollectionsKt.toMutableSet((Iterable)eventStreams));
        }
    }

    private final void mapEventsToStreams(Map<EventTypeID, ? extends Set<? extends Topic>> eventTypeToTopics, Map<Topic, ? extends Set<? extends EventStreamBase>> topicToStreams) {
        Map evtTypeToStrms = new LinkedHashMap();
        for (Map.Entry<EventTypeID, Set<Topic>> entry : eventTypeToTopics.entrySet()) {
            EventTypeID eventType = entry.getKey();
            Set<Topic> topics = entry.getValue();
            Set streams = new LinkedHashSet();
            for (Enum topic : topics) {
                if (!topicToStreams.containsKey(topic)) {
                    Logger.Companion.alwaysWarn("Topic " + topic + " has no associated stream");
                    continue;
                }
                Collection collection = streams;
                Set<? extends EventStreamBase> set = topicToStreams.get(topic);
                Intrinsics.checkNotNull(set);
                Iterable iterable = set;
                CollectionsKt.addAll(collection, iterable);
            }
            evtTypeToStrms.put(eventType, streams);
        }
        this.eventTypeToStreams = evtTypeToStrms;
    }

    @Nullable
    public final Set<EventStreamBase> getStreams(@NotNull EventTypeID eventType) {
        Intrinsics.checkNotNullParameter((Object)eventType, "eventType");
        return this.eventTypeToStreams.get((Object)eventType);
    }
}

