/*
 * Decompiled with CFR 0.152.
 */
package eventreports;

import eventreports.EventBase;
import eventreports.EventStreamBase;
import eventreports.EventStreamMapper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\rH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Leventreports/EventReporter;", "Topic", "", "", "eventStreamMapper", "Leventreports/EventStreamMapper;", "(Leventreports/EventStreamMapper;)V", "reportEvent", "", "event", "Leventreports/EventBase;", "reportEvents", "events", "", "overrideStreams", "Leventreports/EventStreamBase;", "Shared"})
public class EventReporter<Topic extends Enum<Topic>> {
    @NotNull
    private final EventStreamMapper<Topic> eventStreamMapper;

    public EventReporter(@NotNull EventStreamMapper<Topic> eventStreamMapper) {
        Intrinsics.checkNotNullParameter(eventStreamMapper, "eventStreamMapper");
        this.eventStreamMapper = eventStreamMapper;
    }

    public void reportEvents(@NotNull List<? extends EventBase> events, @Nullable List<? extends EventStreamBase> overrideStreams) {
        Intrinsics.checkNotNullParameter(events, "events");
        LinkedHashMap<EventStreamBase, List<EventBase>> streamToEvents = new LinkedHashMap<EventStreamBase, List<EventBase>>();
        for (EventBase entry : events) {
            Collection eventStreams;
            List<? extends EventStreamBase> list2 = overrideStreams;
            Collection collection = eventStreams = list2 == null ? (Collection)this.eventStreamMapper.getStreams(entry.getEventTypeID()) : (Collection)list2;
            if (eventStreams == null || eventStreams.isEmpty()) {
                Logger.Companion.alwaysWarn("Event " + entry + " has no associated stream; could not report");
                continue;
            }
            for (EventStreamBase eventStream : eventStreams) {
                Unit unit;
                Unit unit2;
                List list3 = (List)streamToEvents.get(eventStream);
                if (list3 == null) {
                    unit2 = null;
                } else {
                    ((Collection)list3).add(entry);
                    unit2 = Unit.INSTANCE;
                }
                if ((unit = unit2) != null) continue;
                EventBase[] eventBaseArray = new EventBase[]{entry};
                streamToEvents.putIfAbsent(eventStream, CollectionsKt.mutableListOf(eventBaseArray));
            }
        }
        for (Map.Entry entry : ((Map)streamToEvents).entrySet()) {
            EventStreamBase stream = (EventStreamBase)entry.getKey();
            List evtList = (List)entry.getValue();
            stream.addEvents(evtList);
        }
    }

    public static /* synthetic */ void reportEvents$default(EventReporter eventReporter, List list2, List list3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportEvents");
        }
        if ((n & 2) != 0) {
            list3 = null;
        }
        eventReporter.reportEvents(list2, list3);
    }

    public final void reportEvent(@NotNull EventBase event) {
        Intrinsics.checkNotNullParameter(event, "event");
        EventReporter.reportEvents$default(this, CollectionsKt.listOf(event), null, 2, null);
    }
}

