/*
 * Decompiled with CFR 0.152.
 */
package datastructures.treap;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001:\u0002\u000f\u0010J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0000H&J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0000H\u0016J\b\u0010\u000e\u001a\u00020\u0000H&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0011"}, d2={"Ldatastructures/treap/TreapKey;", "", "treapKey", "getTreapKey", "()Ljava/lang/Object;", "treapKeyHashCode", "", "getTreapKeyHashCode", "()I", "treapPriority", "getTreapPriority", "compareKeyTo", "that", "comparePriorityTo", "precompute", "Hashed", "Sorted", "GeneralUtils"})
public interface TreapKey {
    @Nullable
    public Object getTreapKey();

    public int compareKeyTo(@NotNull TreapKey var1);

    public int getTreapKeyHashCode();

    public int getTreapPriority();

    public int comparePriorityTo(@NotNull TreapKey var1);

    @NotNull
    public TreapKey precompute();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001\fJ\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016R\u0012\u0010\u0004\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Ldatastructures/treap/TreapKey$Sorted;", "K", "", "Ldatastructures/treap/TreapKey;", "treapKey", "getTreapKey", "()Ljava/lang/Comparable;", "compareKeyTo", "", "that", "precompute", "Ldatastructures/treap/TreapKey$Sorted$FromKey;", "FromKey", "GeneralUtils"})
    public static interface Sorted<K extends Comparable<? super K>>
    extends TreapKey {
        @NotNull
        public K getTreapKey();

        @Override
        public int compareKeyTo(@NotNull TreapKey var1);

        @Override
        @NotNull
        public FromKey<K> precompute();

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldatastructures/treap/TreapKey$Sorted$FromKey;", "K", "", "Ldatastructures/treap/TreapKey$Sorted;", "treapKey", "(Ljava/lang/Comparable;)V", "getTreapKey", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "treapPriority", "", "getTreapPriority", "()I", "GeneralUtils"})
        public static final class FromKey<K extends Comparable<? super K>>
        implements Sorted<K> {
            @NotNull
            private final K treapKey;
            private final int treapPriority;

            public FromKey(@NotNull K treapKey) {
                Intrinsics.checkNotNullParameter(treapKey, "treapKey");
                this.treapKey = treapKey;
                this.treapPriority = DefaultImpls.getTreapPriority(this);
            }

            @Override
            @NotNull
            public K getTreapKey() {
                return this.treapKey;
            }

            @Override
            public int getTreapPriority() {
                return this.treapPriority;
            }

            @Override
            public int compareKeyTo(@NotNull TreapKey that) {
                return DefaultImpls.compareKeyTo(this, that);
            }

            @Override
            @NotNull
            public FromKey<K> precompute() {
                return DefaultImpls.precompute(this);
            }

            @Override
            public int getTreapKeyHashCode() {
                return DefaultImpls.getTreapKeyHashCode(this);
            }

            @Override
            public int comparePriorityTo(@NotNull TreapKey that) {
                return DefaultImpls.comparePriorityTo(this, that);
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            /*
             * WARNING - void declaration
             */
            public static <K extends Comparable<? super K>> int compareKeyTo(@NotNull Sorted<K> this_, @NotNull TreapKey that) {
                void var2_2;
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(that, "that");
                Object $this$uncheckedAs$iv = that.getTreapKey();
                boolean $i$f$uncheckedAs = false;
                return this_.getTreapKey().compareTo(var2_2);
            }

            @NotNull
            public static <K extends Comparable<? super K>> FromKey<K> precompute(@NotNull Sorted<K> this_) {
                Intrinsics.checkNotNullParameter(this_, "this");
                return new FromKey<K>(this_.getTreapKey());
            }

            public static <K extends Comparable<? super K>> int getTreapKeyHashCode(@NotNull Sorted<K> this_) {
                Intrinsics.checkNotNullParameter(this_, "this");
                return datastructures.treap.TreapKey$DefaultImpls.getTreapKeyHashCode(this_);
            }

            public static <K extends Comparable<? super K>> int getTreapPriority(@NotNull Sorted<K> this_) {
                Intrinsics.checkNotNullParameter(this_, "this");
                return datastructures.treap.TreapKey$DefaultImpls.getTreapPriority(this_);
            }

            public static <K extends Comparable<? super K>> int comparePriorityTo(@NotNull Sorted<K> this_, @NotNull TreapKey that) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(that, "that");
                return datastructures.treap.TreapKey$DefaultImpls.comparePriorityTo(this_, that);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u000bJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016R\u0012\u0010\u0003\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"Ldatastructures/treap/TreapKey$Hashed;", "K", "Ldatastructures/treap/TreapKey;", "treapKey", "getTreapKey", "()Ljava/lang/Object;", "compareKeyTo", "", "that", "precompute", "Ldatastructures/treap/TreapKey$Hashed$FromKey;", "FromKey", "GeneralUtils"})
    public static interface Hashed<K>
    extends TreapKey {
        public K getTreapKey();

        @Override
        public int compareKeyTo(@NotNull TreapKey var1);

        @Override
        @NotNull
        public FromKey<K> precompute();

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0003\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Ldatastructures/treap/TreapKey$Hashed$FromKey;", "K", "Ldatastructures/treap/TreapKey$Hashed;", "treapKey", "(Ljava/lang/Object;)V", "getTreapKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "treapKeyHashCode", "", "getTreapKeyHashCode", "()I", "treapPriority", "getTreapPriority", "GeneralUtils"})
        public static final class FromKey<K>
        implements Hashed<K> {
            private final K treapKey;
            private final int treapKeyHashCode;
            private final int treapPriority;

            public FromKey(K treapKey) {
                this.treapKey = treapKey;
                K k = this.getTreapKey();
                this.treapKeyHashCode = k == null ? 0 : k.hashCode();
                this.treapPriority = DefaultImpls.getTreapPriority(this);
            }

            @Override
            public K getTreapKey() {
                return this.treapKey;
            }

            @Override
            public int getTreapKeyHashCode() {
                return this.treapKeyHashCode;
            }

            @Override
            public int getTreapPriority() {
                return this.treapPriority;
            }

            @Override
            public int compareKeyTo(@NotNull TreapKey that) {
                return DefaultImpls.compareKeyTo(this, that);
            }

            @Override
            @NotNull
            public FromKey<K> precompute() {
                return DefaultImpls.precompute(this);
            }

            @Override
            public int comparePriorityTo(@NotNull TreapKey that) {
                return DefaultImpls.comparePriorityTo(this, that);
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static <K> int compareKeyTo(@NotNull Hashed<K> this_, @NotNull TreapKey that) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(that, "that");
                int thisHash = this_.getTreapKeyHashCode();
                int thatHash = that.getTreapKeyHashCode();
                return thisHash < thatHash ? -1 : (thisHash > thatHash ? 1 : 0);
            }

            @NotNull
            public static <K> FromKey<K> precompute(@NotNull Hashed<K> this_) {
                Intrinsics.checkNotNullParameter(this_, "this");
                return new FromKey<K>(this_.getTreapKey());
            }

            public static <K> int getTreapKeyHashCode(@NotNull Hashed<K> this_) {
                Intrinsics.checkNotNullParameter(this_, "this");
                return datastructures.treap.TreapKey$DefaultImpls.getTreapKeyHashCode(this_);
            }

            public static <K> int getTreapPriority(@NotNull Hashed<K> this_) {
                Intrinsics.checkNotNullParameter(this_, "this");
                return datastructures.treap.TreapKey$DefaultImpls.getTreapPriority(this_);
            }

            public static <K> int comparePriorityTo(@NotNull Hashed<K> this_, @NotNull TreapKey that) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(that, "that");
                return datastructures.treap.TreapKey$DefaultImpls.comparePriorityTo(this_, that);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static int getTreapKeyHashCode(@NotNull TreapKey this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Object object = this_.getTreapKey();
            return object == null ? 0 : object.hashCode();
        }

        public static int getTreapPriority(@NotNull TreapKey this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Object object = this_.getTreapKey();
            int h = object == null ? 0 : object.hashCode();
            h ^= h >>> 16;
            h = (int)((long)h * 2246822507L);
            h ^= h >>> 13;
            h = (int)((long)h * 3266489909L);
            h ^= h >>> 16;
            return h;
        }

        public static int comparePriorityTo(@NotNull TreapKey this_, @NotNull TreapKey that) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(that, "that");
            int thisPri = this_.getTreapPriority();
            int thatPri = that.getTreapPriority();
            return thisPri < thatPri ? -1 : (thisPri > thatPri ? 1 : this_.compareKeyTo(that));
        }
    }
}

