/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.Graph;
import datastructures.MultiMap;
import datastructures.MutableLabelledGraph;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u0010*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0010B9\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u00028\u00012\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R&\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldatastructures/LabelledGraph;", "V", "E", "Ldatastructures/Graph;", "relation", "Ldatastructures/MultiMap;", "labelMapping", "", "Lkotlin/Pair;", "(Ldatastructures/MultiMap;Ljava/util/Map;)V", "getEdgeLabel", "src", "tgt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Companion", "GeneralUtils"})
public class LabelledGraph<V, E>
extends Graph<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiMap<V, V> relation;
    @NotNull
    private final Map<Pair<V, V>, E> labelMapping;

    public LabelledGraph(@NotNull MultiMap<V, V> relation, @NotNull Map<Pair<V, V>, ? extends E> labelMapping) {
        Intrinsics.checkNotNullParameter(relation, "relation");
        Intrinsics.checkNotNullParameter(labelMapping, "labelMapping");
        super(relation);
        this.relation = relation;
        this.labelMapping = labelMapping;
    }

    public E getEdgeLabel(V src, V tgt) {
        E e = this.labelMapping.get(TuplesKt.to(src, tgt));
        if (e == null) {
            throw new IllegalStateException(("edge (" + src + ", " + tgt + ") is not present in this graph").toString());
        }
        return e;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this.relation.getPairs(), "\n", null, null, 0, null, new Function1<Pair<? extends V, ? extends V>, CharSequence>(this){
            final /* synthetic */ LabelledGraph<V, E> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Pair<? extends V, ? extends V> $dstr$src$tgt) {
                Intrinsics.checkNotNullParameter($dstr$src$tgt, "$dstr$src$tgt");
                V src = $dstr$src$tgt.component1();
                V tgt = $dstr$src$tgt.component2();
                return src + " -(" + LabelledGraph.access$getLabelMapping$p(this.this$0).get(TuplesKt.to(src, tgt)) + ")-> " + tgt;
            }
        }, 30, null);
    }

    public static final /* synthetic */ Map access$getLabelMapping$p(LabelledGraph $this) {
        return $this.labelMapping;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Ldatastructures/LabelledGraph$Companion;", "", "()V", "singleEdge", "Ldatastructures/LabelledGraph;", "V", "E", "source", "label", "sink", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ldatastructures/LabelledGraph;", "GeneralUtils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <V, E> LabelledGraph<V, E> singleEdge(V source, E label, V sink) {
            MutableLabelledGraph<V, E> mutable = new MutableLabelledGraph<V, E>();
            mutable.put(source, label, sink);
            return mutable.freeze();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

